% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif.R
\name{autoplot.TaskClassif}
\alias{autoplot.TaskClassif}
\title{Plot for Classification Tasks}
\usage{
\method{autoplot}{TaskClassif}(object, type = "target", ...)
}
\arguments{
\item{object}{(\link[mlr3:TaskClassif]{mlr3::TaskClassif}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional argument, possibly passed down to the underlying plot functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:TaskClassif]{mlr3::TaskClassif}, depending on argument \code{type}:
\itemize{
\item \code{"target"} (default): Bar plot of the target variable (default).
\item \code{"duo"}: Passes data and additional arguments down to \code{\link[GGally:ggduo]{GGally::ggduo()}}.
\code{columnsX} is target, \code{columnsY} is features.
\item \code{"pairs"}: Passes data and additional arguments down to \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Color is set to target column.
}
}
\examples{
library(mlr3)
library(mlr3viz)

task = mlr_tasks$get("iris")

head(fortify(task))
autoplot(task)
autoplot(task$clone()$select(c("Sepal.Length", "Sepal.Width")), type = "pairs")
autoplot(task, type = "duo")
}
