% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchCallbacks.R
\name{mlr_pipeops_torch_callbacks}
\alias{mlr_pipeops_torch_callbacks}
\alias{PipeOpTorchCallbacks}
\title{Callback Configuration}
\description{
Configures the callbacks of a deep learning model.
}
\section{Parameters}{

The parameters are defined dynamically from the callbacks, where the id of the respective callbacks is the
respective set id.
}

\section{Input and Output Channels}{

There is one input channel \code{"input"} and one output channel \code{"output"}.
During \emph{training}, the channels are of class \code{\link{ModelDescriptor}}.
During \emph{prediction}, the channels are of class \code{\link[mlr3:Task]{Task}}.
}

\section{State}{

The state is the value calculated by the public method \code{shapes_out()}.
}

\section{Internals}{

During training the callbacks are cloned and added to the \code{\link{ModelDescriptor}}.
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
po_cb = po("torch_callbacks", "checkpoint")
po_cb$param_set
mdin = po("torch_ingress_num")$train(list(tsk("iris")))
mdin[[1L]]$callbacks
mdout = po_cb$train(mdin)[[1L]]
mdout$callbacks
# Can be called again
po_cb1 = po("torch_callbacks", t_clbk("progress"))
mdout1 = po_cb1$train(list(mdout))[[1L]]
mdout1$callbacks
\dontshow{\}) # examplesIf}
}
\seealso{
Other Model Configuration: 
\code{\link{ModelDescriptor}()},
\code{\link{mlr_pipeops_torch_loss}},
\code{\link{mlr_pipeops_torch_optimizer}},
\code{\link{model_descriptor_union}()}

Other PipeOp: 
\code{\link{mlr_pipeops_module}},
\code{\link{mlr_pipeops_torch_optimizer}}
}
\concept{Model Configuration}
\concept{PipeOp}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpTorchCallbacks}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTorchCallbacks-new}{\code{PipeOpTorchCallbacks$new()}}
\item \href{#method-PipeOpTorchCallbacks-clone}{\code{PipeOpTorchCallbacks$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchCallbacks-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchCallbacks-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchCallbacks$new(
  callbacks = list(),
  id = "torch_callbacks",
  param_vals = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callbacks}}{(\code{list} of \code{\link{TorchCallback}}s) \cr
The callbacks (or something convertible via \code{\link[=as_torch_callbacks]{as_torch_callbacks()}}).
Must have unique ids.
All callbacks are cloned during construction.}

\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchCallbacks-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchCallbacks-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchCallbacks$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
