% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchCallback.R
\docType{data}
\name{mlr3torch_callbacks}
\alias{mlr3torch_callbacks}
\title{Dictionary of Torch Callbacks}
\format{
An object of class \code{DictionaryMlr3torchCallbacks} (inherits from \code{Dictionary}, \code{R6}) of length 12.
}
\usage{
mlr3torch_callbacks
}
\description{
A \code{\link[mlr3misc:Dictionary]{mlr3misc::Dictionary}} of torch callbacks.
Use \code{\link[=t_clbk]{t_clbk()}} to conveniently retrieve callbacks.
Can be converted to a \code{\link[data.table:data.table]{data.table}} using
\code{\link[data.table:as.data.table]{as.data.table}}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mlr3torch_callbacks$get("checkpoint")
# is the same as
t_clbk("checkpoint")
# convert to a data.table
as.data.table(mlr3torch_callbacks)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Callback: 
\code{\link{TorchCallback}},
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr_callback_set}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.progress}},
\code{\link{mlr_callback_set.tb}},
\code{\link{mlr_callback_set.unfreeze}},
\code{\link{mlr_context_torch}},
\code{\link{t_clbk}()},
\code{\link{torch_callback}()}

Other Dictionary: 
\code{\link{mlr3torch_losses}},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_opt}()}
}
\concept{Callback}
\concept{Dictionary}
\keyword{datasets}
