% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingRepeatedSpCVEnv.R
\name{mlr_resamplings_repeated_spcv_env}
\alias{mlr_resamplings_repeated_spcv_env}
\alias{ResamplingRepeatedSpCVEnv}
\title{(blockCV) Repeated "environmental blocking" resampling}
\description{
Splits data by clustering in the feature space.
See the upstream implementation at \code{blockCV::cv_cluster()} and
Valavi et al. (2018) for further information.
}
\details{
Useful when the dataset is supposed to be split on environmental information
which is present in features.
The method allows for a combination of multiple features for clustering.

The input of raster images directly as in \code{blockCV::cv_cluster()} is not
supported. See \CRANpkg{mlr3spatial} and its raster DataBackends for such
support in \CRANpkg{mlr3}.
}
\section{Parameters}{

\itemize{
\item \code{folds} (\code{integer(1)})\cr
Number of folds.
\item \code{features} (\code{character()})\cr
The features to use for clustering.
}


\itemize{
\item \code{repeats} (\code{integer(1)})\cr
Number of repeats.
}
}

\examples{
\donttest{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {
  library(mlr3)
  task = tsk("ecuador")

  # Instantiate Resampling
  rrcv = rsmp("repeated_spcv_env", folds = 4, repeats = 2)
  rrcv$instantiate(task)

  # Individual sets:
  rrcv$train_set(1)
  rrcv$test_set(1)
  intersect(rrcv$train_set(1), rrcv$test_set(1))

  # Internal storage:
  rrcv$instance
}
}
}
\references{
Valavi R, Elith J, Lahoz-Monfort JJ, Guillera-Arroita G (2018).
\dQuote{blockCV: an R package for generating spatially or environmentally separated folds for k-fold cross-validation of species distribution models.}
\emph{bioRxiv}.
\doi{10.1101/357798}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingRepeatedSpCVEnv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingRepeatedSpCVEnv-new}{\code{ResamplingRepeatedSpCVEnv$new()}}
\item \href{#method-ResamplingRepeatedSpCVEnv-folds}{\code{ResamplingRepeatedSpCVEnv$folds()}}
\item \href{#method-ResamplingRepeatedSpCVEnv-repeats}{\code{ResamplingRepeatedSpCVEnv$repeats()}}
\item \href{#method-ResamplingRepeatedSpCVEnv-instantiate}{\code{ResamplingRepeatedSpCVEnv$instantiate()}}
\item \href{#method-ResamplingRepeatedSpCVEnv-clone}{\code{ResamplingRepeatedSpCVEnv$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVEnv-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVEnv-new}{}}}
\subsection{Method \code{new()}}{
Create an "Environmental Block" repeated resampling instance.

For a list of available arguments, please see \link[blockCV:cv_cluster]{blockCV::cv_cluster}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$new(id = "repeated_spcv_env")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVEnv-folds"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVEnv-folds}{}}}
\subsection{Method \code{folds()}}{
Translates iteration numbers to fold number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$folds(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVEnv-repeats"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVEnv-repeats}{}}}
\subsection{Method \code{repeats()}}{
Translates iteration numbers to repetition number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$repeats(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVEnv-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVEnv-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link[mlr3:Task]{mlr3::Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVEnv-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVEnv-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
