% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSpCVTiles.R
\name{mlr_resamplings_spcv_tiles}
\alias{mlr_resamplings_spcv_tiles}
\alias{ResamplingSpCVTiles}
\title{(sperrorest) Spatial "Tiles" resampling}
\description{
Spatial partitioning using rectangular tiles.
Small partitions can optionally be merged into adjacent ones to avoid
partitions with too few observations.
This method is similar to \code{ResamplingSpCVBlock} by making use of
rectangular zones in the coordinate space.
See the upstream implementation at \code{sperrorest::partition_disc()} and
Brenning (2012) for further information.
}
\section{Parameters}{

\itemize{
\item \code{dsplit} (\code{integer(2)})\cr
Equidistance of splits in (possibly rotated) x direction (\code{dsplit[1]}) and y direction (\code{dsplit[2]}) used to define tiles.
If dsplit is of length 1, its value is recycled.
Either \code{dsplit} or \code{nsplit} must be specified.
\item \code{nsplit} (\code{integer(2)})\cr
Number of splits in (possibly rotated) x direction (\code{nsplit[1]}) and y direction (\code{nsplit[2]}) used to define tiles.
If \code{nsplit} is of length 1, its value is recycled.
\item \code{rotation} (\code{character(1)})\cr
Whether and how the rectangular grid should be rotated; random rotation is only possible between -45 and +45 degrees.
Accepted values: One of \code{c("none", "random", "user")}.
\item \code{user_rotation} (\code{character(1)})\cr
Only used when \code{rotation = "user"}.
Angle(s) (in degrees) by which the rectangular grid is to be rotated in
each repetition.
Either a vector of same length as \code{repeats}, or a single number that
will be replicated \code{length(repeats)} times.
\item \code{offset} (\code{logical(1)})\cr
Whether and how the rectangular grid should be shifted by an offset.
Accepted values: One of \code{c("none", "random", "user")}.
\item \code{user_offset} (\code{logical(1)})\cr
Only used when \code{offset = "user"}.
A list (or vector) of two components specifying a shift of the rectangular
grid in (possibly rotated) x and y direction.
The offset values are relative values, a value of 0.5 resulting in a
one-half tile shift towards the left, or upward.
If this is a list, its first (second) component refers to the rotated
x (y) direction, and both components must have same length as \code{repeats}
(or length 1).
If a vector of length 2 (or list components have length 1), the two values
will be interpreted as relative shifts in (rotated) x and y direction,
respectively, and will therefore be recycled as needed (\code{length(repeats)}
times each).
\item \code{reassign} (\code{logical(1)})\cr
If \code{TRUE}, 'small' tiles (as per \code{min_frac} and \code{min_n}) are merged with
(smallest) adjacent tiles.
If \code{FALSE}, small tiles are 'eliminated', i.e., set to \code{NA.}
\item \code{min_frac} (\code{numeric(1)})\cr
Value must be >=0, <1.
Minimum relative size of partition as percentage of sample.
\item \code{min_n} (\code{integer(1)})\cr
Minimum number of samples per partition.
\item \code{iterate} (\code{integer(1)})\cr
Passed down to \code{\link[sperrorest:tile_neighbors]{sperrorest::tile_neighbors()}}.
}
}

\examples{
if (mlr3misc::require_namespaces("sperrorest", quietly = TRUE)) {
  library(mlr3)
  task = tsk("ecuador")

  # Instantiate Resampling
  rcv = rsmp("spcv_tiles", nsplit = c(4L, 3L), reassign = FALSE)
  rcv$instantiate(task)

  # Individual sets:
  rcv$train_set(1)
  rcv$test_set(1)
  # check that no obs are in both sets
  intersect(rcv$train_set(1), rcv$test_set(1)) # good!

  # Internal storage:
  rcv$instance # table
}
}
\references{
Brenning A (2012).
\dQuote{Spatial cross-validation and bootstrap for the assessment of prediction rules in remote sensing: The R package sperrorest.}
In \emph{2012 IEEE International Geoscience and Remote Sensing Symposium}.
\doi{10.1109/igarss.2012.6352393}.
}
\seealso{
ResamplingSpCVBlock
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingSpCVTiles}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingSpCVTiles-new}{\code{ResamplingSpCVTiles$new()}}
\item \href{#method-ResamplingSpCVTiles-instantiate}{\code{ResamplingSpCVTiles$instantiate()}}
\item \href{#method-ResamplingSpCVTiles-clone}{\code{ResamplingSpCVTiles$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVTiles-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVTiles-new}{}}}
\subsection{Method \code{new()}}{
Create a "Spatial 'Tiles' resampling" resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVTiles$new(id = "spcv_tiles")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.
For a list of available arguments, please see
\link[sperrorest:partition_tiles]{sperrorest::partition_tiles}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVTiles-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVTiles-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVTiles$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVTiles-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVTiles-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVTiles$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
