% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassifST.R
\name{TaskClassifST}
\alias{TaskClassifST}
\title{Crate a Spatiotemporal Classification Task}
\description{
This task specializes \link{Task} and \link{TaskSupervised} for
spatiotemporal classification problems. The target column is assumed to be a
factor. The \code{task_type} is set to \code{"classif"} and \code{"spatiotemporal"}.

A spatial example task is available via \code{tsk("ecuador")}, a spatiotemporal
one via \code{tsk("cookfarm")}.

The coordinate reference system passed during initialization must match the
one which was used during data creation, otherwise offsets of multiple meters
may occur. By default, coordinates are not used as features. This can be
changed by setting \code{extra_args$coords_as_features = TRUE}.
}
\examples{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {

  data = mlr3::as_data_backend(ecuador)
  task = TaskClassifST$new("ecuador",
    backend = data, target = "slides",
    positive = "TRUE", extra_args = list(coordinate_names = c("x", "y"))
  )

  # passing objects of class 'sf' is also supported
  data_sf = sf::st_as_sf(ecuador, coords = c("x", "y"), crs = 4326)
  task = TaskClassifST$new("ecuador_sf",
    backend = data_sf, target = "slides", positive = "TRUE"
  )

  task$task_type
  task$formula()
  task$class_names
  task$positive
  task$negative
  task$coordinates()
  task$coordinate_names
}
}
\seealso{
Other Task: 
\code{\link{TaskRegrST}},
\code{\link{mlr_tasks_cookfarm}},
\code{\link{mlr_tasks_diplodia}},
\code{\link{mlr_tasks_ecuador}}
}
\concept{Task}
\section{Super classes}{
\code{\link[mlr3:Task]{mlr3::Task}} -> \code{\link[mlr3:TaskSupervised]{mlr3::TaskSupervised}} -> \code{\link[mlr3:TaskClassif]{mlr3::TaskClassif}} -> \code{TaskClassifST}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{extra_args}}{(named \code{list()})\cr
Additional task arguments set during construction.
Required for \code{\link[=convert_task]{convert_task()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TaskClassifST$new()}}
\item \href{#method-coordinates}{\code{TaskClassifST$coordinates()}}
\item \href{#method-print}{\code{TaskClassifST$print()}}
\item \href{#method-clone}{\code{TaskClassifST$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="cbind">}\href{../../mlr3/html/Task.html#method-cbind}{\code{mlr3::Task$cbind()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="filter">}\href{../../mlr3/html/Task.html#method-filter}{\code{mlr3::Task$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="format">}\href{../../mlr3/html/Task.html#method-format}{\code{mlr3::Task$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="formula">}\href{../../mlr3/html/Task.html#method-formula}{\code{mlr3::Task$formula()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="head">}\href{../../mlr3/html/Task.html#method-head}{\code{mlr3::Task$head()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="help">}\href{../../mlr3/html/Task.html#method-help}{\code{mlr3::Task$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="levels">}\href{../../mlr3/html/Task.html#method-levels}{\code{mlr3::Task$levels()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="missings">}\href{../../mlr3/html/Task.html#method-missings}{\code{mlr3::Task$missings()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rbind">}\href{../../mlr3/html/Task.html#method-rbind}{\code{mlr3::Task$rbind()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rename">}\href{../../mlr3/html/Task.html#method-rename}{\code{mlr3::Task$rename()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="select">}\href{../../mlr3/html/Task.html#method-select}{\code{mlr3::Task$select()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_col_roles">}\href{../../mlr3/html/Task.html#method-set_col_roles}{\code{mlr3::Task$set_col_roles()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_row_roles">}\href{../../mlr3/html/Task.html#method-set_row_roles}{\code{mlr3::Task$set_row_roles()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskClassif" data-id="data">}\href{../../mlr3/html/TaskClassif.html#method-data}{\code{mlr3::TaskClassif$data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskClassif" data-id="droplevels">}\href{../../mlr3/html/TaskClassif.html#method-droplevels}{\code{mlr3::TaskClassif$droplevels()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskClassif" data-id="truth">}\href{../../mlr3/html/TaskClassif.html#method-truth}{\code{mlr3::TaskClassif$truth()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new spatiotemporal resampling Task
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskClassifST$new(
  id,
  backend,
  target,
  positive = NULL,
  extra_args = list(coords_as_features = FALSE, crs = NA, coordinate_names = NA)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\verb{[character(1)]}\cr
Identifier for the task.}

\item{\code{backend}}{\link{DataBackend}\cr
Either a \link{DataBackend}, or any object which is convertible to a
DataBackend with \code{as_data_backend()}. E.g., a \code{data.frame()} will be
converted to a \link{DataBackendDataTable}.}

\item{\code{target}}{\verb{[character(1)]}\cr
Name of the target column.}

\item{\code{positive}}{\verb{[character(1)]}\cr
Only for binary classification: Name of the positive class.
The levels of the target columns are reordered accordingly, so that the
first element of \verb{$class_names} is the positive class, and the second
element is the negative class.}

\item{\code{extra_args}}{\verb{[named list]}\cr
Additional task arguments set during construction. Required for
\code{\link[=convert_task]{convert_task()}}.
\itemize{
\item crs \verb{[character(1)]}\cr
Coordinate reference system. Either a PROJ string or an
\href{https://epsg.io/}{EPSG} code.
\item coords_as_features \verb{[logical(1)]}\cr
Whether the coordinates should also be used as features.
\item coordinate_names \verb{[character(2)]}\cr
The variables names of the coordinates in the data.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-coordinates"></a>}}
\if{latex}{\out{\hypertarget{method-coordinates}{}}}
\subsection{Method \code{coordinates()}}{
Return the coordinates of the task
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskClassifST$coordinates(rows = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{Row IDs. Can be used to subset the returned coordinates.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskClassifST$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed to the \verb{$print()} method of the superclass.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskClassifST$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
