% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendRaster.R
\name{DataBackendRaster}
\alias{DataBackendRaster}
\title{DataBackend for raster objects}
\description{
\link[mlr3:DataBackend]{mlr3::DataBackend} for raster objects:
\itemize{
\item \link[raster:brick]{raster::brick}
\item \link[stars:st_as_stars]{stars::st_as_stars}
\item \link[terra:SpatRaster-class]{terra::SpatRaster}
}

The DataBackend can be constructed using the spatial objects listed above.
Internally {terra} is used for processing operations.
}
\section{Read mode}{

There are two different ways the reading of values is performed internally:
\itemize{
\item "Block mode" reads complete rows of the raster file and subsets the
requested cells. This mode is faster than "cell mode" if the complete raster
file is iterated over.
\item "Cell mode" reads individual cells. This is faster than "block mode" if
only a few cells are sampled.
}

"Block mode" is activated if \verb{$data(rows)} is used with a increasing integer
sequence e.g. \code{200:300}. If only a single cell is requested, "cell mode" is
used.
}

\section{Super class}{
\code{\link[mlr3:DataBackend]{mlr3::DataBackend}} -> \code{DataBackendRaster}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{compact_seq}}{\code{logical(1)}\cr
If \code{TRUE}, row ids are a natural sequence from 1 to \code{nrow(data)} (determined internally).
In this case, row lookup uses faster positional indices instead of equi joins.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{rownames}}{(\code{integer()})\cr
Returns vector of all distinct row identifiers, i.e. the contents of the primary key column.}

\item{\code{colnames}}{(\code{character()})\cr
Returns vector of all column names.}

\item{\code{nrow}}{(\code{integer(1)})\cr
Number of rows (observations).}

\item{\code{ncol}}{(\code{integer(1)})\cr
Number of columns (variables).}

\item{\code{stack}}{(\code{SpatRaster})\cr
Raster stack.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataBackendRaster$new()}}
\item \href{#method-data}{\code{DataBackendRaster$data()}}
\item \href{#method-head}{\code{DataBackendRaster$head()}}
\item \href{#method-distinct}{\code{DataBackendRaster$distinct()}}
\item \href{#method-missings}{\code{DataBackendRaster$missings()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="DataBackend" data-id="format">}\href{../../mlr3/html/DataBackend.html#method-format}{\code{mlr3::DataBackend$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="DataBackend" data-id="print">}\href{../../mlr3/html/DataBackend.html#method-print}{\code{mlr3::DataBackend$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a backend for a raster objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendRaster$new(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\verb{Spatial object})\cr
Supported objects:
\itemize{
\item \link[raster:brick]{raster::brick}
\item \link[stars:st_as_stars]{stars::st_as_stars}
\item \link[terra:SpatRaster-class]{terra::SpatRaster}
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-data"></a>}}
\if{latex}{\out{\hypertarget{method-data}{}}}
\subsection{Method \code{data()}}{
Returns a slice of the raster in the specified format.
Currently, the only supported formats is \code{"data.table"}.

The rows must be addressed as vector of cells indices, columns must be
referred to via layer names. Queries for rows with no matching row id and
queries for columns with no matching column name are silently ignored.

Rows are guaranteed to be returned in the same order as \code{rows}, columns
may be returned in an arbitrary order. Duplicated row ids result in
duplicated rows, duplicated column names lead to an exception.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendRaster$data(rows, cols, data_format = "data.table")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices. Row indices start with 1 in the upper left corner in the
raster, increase from left to right and then from top to bottom. The last
cell is in the bottom right corner and the row index equals the number of
cells in the raster.}

\item{\code{cols}}{\code{character()}\cr
Column names.}

\item{\code{data_format}}{(\code{character(1)})\cr
Desired data format. Currently only \code{"data.table"} supported.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-head"></a>}}
\if{latex}{\out{\hypertarget{method-head}{}}}
\subsection{Method \code{head()}}{
Retrieve the first \code{n} rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendRaster$head(n = 6L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} of the first \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distinct"></a>}}
\if{latex}{\out{\hypertarget{method-distinct}{}}}
\subsection{Method \code{distinct()}}{
Returns a named list of vectors of distinct values for each column
specified. If \code{na_rm} is \code{TRUE}, missing values are removed from the
returned vectors of distinct values. Non-existing rows and columns are
silently ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendRaster$distinct(rows, cols, na_rm = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices. Row indices start with 1 in the upper left corner in the
raster, increase from left to right and then from top to bottom. The last
cell is in the bottom right corner and the row index equals the number of
cells in the raster.}

\item{\code{cols}}{\code{character()}\cr
Column names.}

\item{\code{na_rm}}{\code{logical(1)}\cr
Whether to remove NAs or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named \code{list()} of distinct values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-missings"></a>}}
\if{latex}{\out{\hypertarget{method-missings}{}}}
\subsection{Method \code{missings()}}{
Returns the number of missing values per column in the specified slice
of data. Non-existing rows and columns are silently ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendRaster$missings(rows, cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices. Row indices start with 1 in the upper left corner in the
raster, increase from left to right and then from top to bottom. The last
cell is in the bottom right corner and the row index equals the number of
cells in the raster.}

\item{\code{cols}}{\code{character()}\cr
Column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Total of missing values per column (named \code{numeric()}).
}
}
}
