% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_return.R
\name{.surv_return}
\alias{.surv_return}
\title{Get Survival Predict Types}
\usage{
.surv_return(
  times = NULL,
  surv = NULL,
  crank = NULL,
  lp = NULL,
  response = NULL
)
}
\arguments{
\item{times}{(\code{numeric()}) \cr Vector of survival times.}

\item{surv}{(\code{matrix()})\cr Matrix of predicted survival probabilities, rows are observations,
columns are times. Number of columns should be equal to length of \code{times}.}

\item{crank}{(\code{numeric()})\cr Relative risk/continuous ranking. Higher value is associated
with higher risk. If \code{NULL} then either set as \code{lp} if available or as the estimated
survival expectation, computed by \code{colSums(surv)}.}

\item{lp}{(\code{numeric()})\cr Predicted linear predictor, used to impute \code{crank} if \code{NULL}.}

\item{response}{(\code{numeric()})\cr Predicted survival time, passed through function without
modification.}
}
\description{
Internal helper function to easily return the correct survival predict types and to
automatically coerce a predicted survival probability matrix to a \link[distr6:Matdist]{distr6::Matdist}.
}
\details{
Uses \link[survivalmodels:surv_to_risk]{survivalmodels::surv_to_risk} to reduce survival matrices to relative
risks / rankings if \code{crank} is NULL.
}
\references{
Sonabend, R., Bender, A., & Vollmer, S. (2021).
Evaluation of survival distribution predictions with discrimination
measures. http://arxiv.org/abs/2112.04828.
}
