% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTaskRegrSurv.R
\name{mlr_pipeops_trafotask_regrsurv}
\alias{mlr_pipeops_trafotask_regrsurv}
\alias{PipeOpTaskRegrSurv}
\title{PipeOpTaskRegrSurv}
\description{
Transform \link{TaskRegr} to \link{TaskSurv}.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \link{PipeOpTaskTransformer}.

The output is the input \link{TaskRegr} transformed to a \link{TaskSurv}.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \link{PipeOpTaskTransformer}.
}

\section{Parameters}{

The parameters are
\itemize{
\item \verb{status :: (numeric(1))}\cr
If \code{NULL} then assumed no censoring in the dataset. Otherwise should be a vector of \code{0/1}s
of same length as the prediction object, where \code{1} is dead and \code{0} censored.
}
}

\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
  library(mlr3)
  library(mlr3pipelines)

  task = tsk("boston_housing")
  po = po("trafotask_regrsurv")

  # assume no censoring
  new_task = po$train(list(task_regr = task, task_surv = NULL))[[1]]
  print(new_task)

  # add censoring
  task_surv = tsk("rats")
  task_regr = po("trafotask_survregr", method = "omit")$train(list(task_surv, NULL))[[1]]
  print(task_regr)
  new_task = po$train(list(task_regr = task_regr, task_surv = task_surv))[[1]]
  new_task$truth()
  task_surv$truth()
}
}
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpPredTransformer}},
\code{\link{PipeOpTaskTransformer}},
\code{\link{PipeOpTransformer}},
\code{\link{mlr_pipeops_survavg}},
\code{\link{mlr_pipeops_trafopred_regrsurv}},
\code{\link{mlr_pipeops_trafopred_survregr}},
\code{\link{mlr_pipeops_trafotask_survregr}}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_regrsurv}},
\code{\link{mlr_pipeops_trafopred_survregr}},
\code{\link{mlr_pipeops_trafotask_survregr}}
}
\concept{PipeOps}
\concept{Transformation PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3proba:PipeOpTransformer]{mlr3proba::PipeOpTransformer}} -> \code{\link[mlr3proba:PipeOpTaskTransformer]{mlr3proba::PipeOpTaskTransformer}} -> \code{PipeOpTaskRegrSurv}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpTaskRegrSurv$new()}}
\item \href{#method-clone}{\code{PipeOpTaskRegrSurv$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskRegrSurv$new(id = "trafotask_regrsurv")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskRegrSurv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
