% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvChamblessAUC.R
\name{mlr_measures_surv.chambless_auc}
\alias{mlr_measures_surv.chambless_auc}
\alias{MeasureSurvChamblessAUC}
\title{Chambless and Diao's AUC Survival Measure}
\description{
Calls \code{\link[survAUC:AUC.ChamDiao]{survAUC::AUC.cd()}}.

Assumes Cox PH model specification.
}
\details{
All measures implemented from \CRANpkg{survAUC} should be used with care, we are aware
of problems in implementation that sometimes cause fatal errors in R. In future updates these
measures will all be re-written and implemented directly in \code{mlr3proba}.
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:\preformatted{MeasureSurvChamblessAUC$new()
mlr_measures$get("surv.chambless_auc")
msr("surv.chambless_auc")
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{lp}
}
}

\references{
Chambless LE, Diao G (2006).
\dQuote{Estimation of time-dependent area under the ROC curve for long-term risk prediction.}
\emph{Statistics in Medicine}, \bold{25}(20), 3474--3486.
\doi{10.1002/sim.2299}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.beggC}},
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.cindex}},
\code{\link{mlr_measures_surv.gonenC}},
\code{\link{mlr_measures_surv.grafSE}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.harrellC}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intloglossSE}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss_se}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.maeSE}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mseSE}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rmseSE}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.unoC}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}

Other AUC survival measures: 
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}}

Other lp survival measures: 
\code{\link{mlr_measures_surv.beggC}},
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.gonenC}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}
}
\concept{AUC survival measures}
\concept{lp survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{\link[mlr3proba:MeasureSurvIntegrated]{mlr3proba::MeasureSurvIntegrated}} -> \code{\link[mlr3proba:MeasureSurvAUC]{mlr3proba::MeasureSurvAUC}} -> \code{MeasureSurvChamblessAUC}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MeasureSurvChamblessAUC$new()}}
\item \href{#method-clone}{\code{MeasureSurvChamblessAUC$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate">}\href{../../mlr3/html/Measure.html#method-aggregate}{\code{mlr3::Measure$aggregate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format">}\href{../../mlr3/html/Measure.html#method-format}{\code{mlr3::Measure$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help">}\href{../../mlr3/html/Measure.html#method-help}{\code{mlr3::Measure$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score">}\href{../../mlr3/html/Measure.html#method-score}{\code{mlr3::Measure$score()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3proba" data-topic="MeasureSurv" data-id="print">}\href{../../mlr3proba/html/MeasureSurv.html#method-print}{\code{mlr3proba::MeasureSurv$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvChamblessAUC$new(integrated = TRUE, times)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{integrated}}{(\code{logical(1)})\cr
If \code{TRUE} (default), returns the integrated score; otherwise, not integrated.}

\item{\code{times}}{(\code{numeric()})\cr
If \code{integrate == TRUE} then a vector of time-points over which to integrate the score.
If \code{integrate == FALSE} then a single time point at which to return the score.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvChamblessAUC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
