% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvCoxPH.R
\name{LearnerSurvCoxPH}
\alias{LearnerSurvCoxPH}
\alias{mlr_learners_surv.coxph}
\title{Cox Proportional Hazards Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[survival:coxph]{survival::coxph()}}.
\itemize{
\item lp is predicted by \code{\link[survival:predict.coxph]{survival::predict.coxph()}}
\item distr is predicted by \code{\link[survival:survfit.coxph]{survival::survfit.coxph()}}
\item \code{crank} is identical to \code{lp}
}
}
\section{Construction}{
\preformatted{LearnerSurvCoxPH$new()
mlr_learners$get("surv.coxph")
lrn("surv.coxph")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, crank, lp}
\item Feature Types: \verb{logical, integer, numeric, factor}
\item Packages: \CRANpkg{survival} \CRANpkg{distr6}
}
}

\references{
\cite{mlr3proba}{cox_1972}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
