% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvGlmnet.R
\name{LearnerSurvGlmnet}
\alias{LearnerSurvGlmnet}
\alias{mlr_learners_surv.glmnet}
\title{GLM with Elastic Net Regularization Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[glmnet:glmnet]{glmnet::glmnet()}}.
\itemize{
\item lp is predicted by \code{\link[glmnet:predict.glmnet]{glmnet::predict.glmnet()}}
\item \code{crank} is identical to \code{lp}
}

Use \link{LearnerSurvGlmnet} and \link{LearnerSurvCVGlmnet} for glmnets without and with internal
cross-validation, respectively. Tuning using the internal optimizer in \link{LearnerSurvCVGlmnet}
may be more efficient when tuning lambda only. However, for tuning multiple hyperparameters,
\CRANpkg{mlr3tuning} and \link{LearnerSurvGlmnet} will likely give better results.

Parameter \code{s} (value of the regularization parameter used for predictions) is set to the median
of the \code{lambda} sequence by default, but needs to be tuned by the user.
}
\section{Construction}{
\preformatted{LearnerSurvGlmnet$new()
mlr_learners$get("surv.glmnet")
lrn("surv.glmnet")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, lp}
\item Feature Types: \verb{integer, numeric, factor}
\item Packages: \CRANpkg{glmnet} \CRANpkg{survival}
}
}

\examples{
library(mlr3)
task = tgen("simsurv")$generate(20)
learner = lrn("surv.glmnet")
resampling = rsmp("cv", folds = 2)
resample(task, learner, resampling)
}
\references{
Jerome Friedman, Trevor Hastie, Robert Tibshirani (2010).
Regularization Paths for Generalized Linear Models via Coordinate Descent.
Journal of Statistical Software, 33(1), 1-22.
\doi{10.18637/jss.v033.i01}.
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
