% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require_namespaces.R
\name{require_namespaces}
\alias{require_namespaces}
\title{Require Multiple Namespaces}
\usage{
require_namespaces(
  pkgs,
  msg = "The following packages could not be loaded: \%s"
)
}
\arguments{
\item{pkgs}{(\code{character()})\cr
Packages to load.}

\item{msg}{(\code{character(1)})\cr
Message to print on error. Use \code{"\%s"} as placeholder for the list of packages.}
}
\value{
(named \code{character()}) of loaded packages (invisibly).
}
\description{
Packages are loaded (not attached) via \code{\link[base:ns-load]{base::requireNamespace()}}.
If at least on package can not be loaded, an exception of class "packageNotFoundError" is raised.
The character vector of missing packages is stored in the condition as \code{packages}.
}
\examples{
require_namespaces("mlr3misc")

# catch condition, return missing packages
tryCatch(require_namespaces(c("mlr3misc", "foobaaar")),
  packageNotFoundError = function(e) e$packages)
}
