% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowwise_table.R
\name{rowwise_table}
\alias{rowwise_table}
\title{Row-Wise Constructor for 'data.table'}
\usage{
rowwise_table(..., .key = NULL)
}
\arguments{
\item{...}{(\code{any})\cr
Arguments: Column names in first rows as formulas (with empty left hand side),
then the tabular data in the following rows.}

\item{.key}{(\code{character(1)})\cr
If not \code{NULL}, set the key via \code{\link[data.table:setkeyv]{data.table::setkeyv()}} after constructing the
table.}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
\description{
Similar to the \CRANpkg{tibble} function \code{tribble()}, this function
allows to construct tabular data in a row-wise fashion.

The first arguments passed as formula will be interpreted as column names.
The remaining arguments will be put into the resulting table.
}
\examples{
rowwise_table(
  ~a, ~b,
  1, "a",
  2, "b"
)
}
