% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_short_string.R
\name{as_short_string}
\alias{as_short_string}
\title{Convert R Object to a Descriptive String}
\usage{
as_short_string(x, width = 30L, num_format = "\%.4g")
}
\arguments{
\item{x}{:: \code{any}\cr
Arbitrary object.}

\item{width}{:: \code{integer(1)}\cr
Truncate strings to width \code{width}.}

\item{num_format}{:: \code{character(1)}\cr
Used to format numerical scalars via \code{\link[base:sprintf]{base::sprintf()}}.}
}
\value{
(\code{character(1)}).
}
\description{
This function is intended to be convert any R object to a short descriptive string,
e.g. in \code{\link[base:print]{base::print()}} functions.

The following rules apply:
\itemize{
\item if \code{x} is \code{atomic()} with length 0 or 1: printed as-is.
\item if \code{x} is \code{atomic()} with length greater than 1, \code{x} is collapsed with \code{","},
and the resulting string is truncated to \code{trunc_width} characters.
\item if \code{x} is an expression: converted to character.
\item Otherwise: the class is printed.
}

If \code{x} is a list, the above rules are applied (non-recursively) to its elements.
}
\examples{
as_short_string(list(a = 1, b = NULL, "foo", c = 1:10))
}
