% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerMbo.R
\name{mlr_tuners_mbo}
\alias{mlr_tuners_mbo}
\alias{TunerMbo}
\title{Tuner using Model Based Optimization}
\description{
\code{TunerMbo} class that implements Model Based Optimization (MBO).
This is a minimal interface internally passing on to \link{OptimizerMbo}.
For additional information and documentation see \link{OptimizerMbo}.
}
\examples{
\donttest{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {

  library(mlr3)
  library(mlr3tuning)

  # single-objective
  task = tsk("wine")
  learner = lrn("classif.rpart", cp = to_tune(lower = 1e-4, upper = 1, logscale = TRUE))
  resampling = rsmp("cv", folds = 3)
  measure = msr("classif.acc")

  instance = TuningInstanceSingleCrit$new(
    task = task,
    learner = learner,
    resampling = resampling,
    measure = measure,
    terminator = trm("evals", n_evals = 5))

  tnr("mbo")$optimize(instance)

  # multi-objective
  task = tsk("wine")
  learner = lrn("classif.rpart", cp = to_tune(lower = 1e-4, upper = 1, logscale = TRUE))
  resampling = rsmp("cv", folds = 3)
  measures = msrs(c("classif.acc", "selected_features"))

  instance = TuningInstanceMultiCrit$new(
    task = task,
    learner = learner,
    resampling = resampling,
    measures = measures,
    terminator = trm("evals", n_evals = 5),
    store_models = TRUE) # required due to selected features

  tnr("mbo")$optimize(instance)
}
}
}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerFromOptimizer]{mlr3tuning::TunerFromOptimizer}} -> \code{TunerMbo}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{loop_function}}{(\link{loop_function} | \code{NULL})\cr
Loop function determining the MBO flavor.}

\item{\code{surrogate}}{(\link{Surrogate} | \code{NULL})\cr
The surrogate.}

\item{\code{acq_function}}{(\link{AcqFunction} | \code{NULL})\cr
The acquisition function.}

\item{\code{acq_optimizer}}{(\link{AcqOptimizer} | \code{NULL})\cr
The acquisition function optimizer.}

\item{\code{args}}{(named \code{list()})\cr
Further arguments passed to the \code{loop_function}.
For example, \code{random_interleave_iter}.}

\item{\code{result_function}}{(\code{function} | \code{NULL})\cr
Optional function called after the optimization terminates.
Determines how the final result of the optimization is calculated.
Requires arguments \code{inst} (the \link[bbotk:OptimInstance]{bbotk::OptimInstance}) and \code{self} (the \link{OptimizerMbo}).
See for example \link{result_by_surrogate_design} which is used by default if the
\link[bbotk:OptimInstance]{bbotk::OptimInstance} has the property \code{"noisy"} (which is the case for a
\link[mlr3tuning:TuningInstanceSingleCrit]{mlr3tuning::TuningInstanceSingleCrit} or \link[mlr3tuning:TuningInstanceMultiCrit]{mlr3tuning::TuningInstanceMultiCrit}).}

\item{\code{param_classes}}{(\code{character()})\cr
Supported parameter classes that the optimizer can optimize.
Determined based on the \code{surrogate} and the \code{acq_optimizer}.
Subclasses of \link[paradox:Param]{paradox::Param}.}

\item{\code{properties}}{(\code{character()})\cr
Set of properties of the optimizer.
Must be a subset of \code{\link[=bbotk_reflections]{bbotk_reflections$optimizer_properties}}.
MBO in principle is very flexible and by default we assume that the optimizer has all properties.
When fully initialized, properties are determined based on the \code{loop_function} and \code{surrogate}.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled prior to optimization if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.
Required packages are determined based on the \code{surrogate} and the \code{acq_optimizer}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerMbo-new}{\code{TunerMbo$new()}}
\item \href{#method-TunerMbo-print}{\code{TunerMbo$print()}}
\item \href{#method-TunerMbo-reset}{\code{TunerMbo$reset()}}
\item \href{#method-TunerMbo-clone}{\code{TunerMbo$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="TunerFromOptimizer" data-id="optimize"><a href='../../mlr3tuning/html/TunerFromOptimizer.html#method-TunerFromOptimizer-optimize'><code>mlr3tuning::TunerFromOptimizer$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerMbo-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerMbo-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
For more information on default values for \code{loop_function}, \code{surrogate}, \code{acq_function} and \code{acq_optimizer}, see \code{?mbo_defaults}.

Note that all the parameters below are simply passed to the \link{OptimizerMbo} and
the respective fields are simply (settable) active bindings to the fields of the \link{OptimizerMbo}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerMbo$new(
  loop_function = NULL,
  surrogate = NULL,
  acq_function = NULL,
  acq_optimizer = NULL,
  args = NULL,
  result_function = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{loop_function}}{(\link{loop_function} | \code{NULL})\cr
Loop function determining the MBO flavor.}

\item{\code{surrogate}}{(\link{Surrogate} | \code{NULL})\cr
The surrogate.}

\item{\code{acq_function}}{(\link{AcqFunction} | \code{NULL})\cr
The acquisition function.}

\item{\code{acq_optimizer}}{(\link{AcqOptimizer} | \code{NULL})\cr
The acquisition function optimizer.}

\item{\code{args}}{(named \code{list()})\cr
Further arguments passed to the \code{loop_function}.
For example, \code{random_interleave_iter}.}

\item{\code{result_function}}{(\code{function} | \code{NULL})\cr
Optional function called after the optimization terminates.
Determines how the final result of the optimization is calculated.
Requires arguments \code{inst} (the \link[bbotk:OptimInstance]{bbotk::OptimInstance}) and \code{self} (the \link{OptimizerMbo}).
See for example \link{result_by_surrogate_design} which is used by default if the
\link[bbotk:OptimInstance]{bbotk::OptimInstance} has the property \code{"noisy"} (which is the case for a
\link[mlr3tuning:TuningInstanceSingleCrit]{mlr3tuning::TuningInstanceSingleCrit} or \link[mlr3tuning:TuningInstanceMultiCrit]{mlr3tuning::TuningInstanceMultiCrit}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerMbo-print"></a>}}
\if{latex}{\out{\hypertarget{method-TunerMbo-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerMbo$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerMbo-reset"></a>}}
\if{latex}{\out{\hypertarget{method-TunerMbo-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the tuner.
Sets the following fields to \code{NULL}:
\code{loop_function}, \code{surrogate}, \code{acq_function}, \code{acq_optimizer}, \code{args}, \code{result_function}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerMbo$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerMbo-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerMbo-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerMbo$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
