% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{fsi}
\alias{fsi}
\title{Syntactic Sugar for Instance Construction}
\usage{
fsi(
  task,
  learner,
  resampling,
  measures = NULL,
  terminator,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  check_values = FALSE
)
}
\arguments{
\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to optimize the feature subset for.}

\item{resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling that is used to evaluated the performance of the feature subsets.
Uninstantiated resamplings are instantiated during construction so that all feature subsets are evaluated on the same data splits.
Already instantiated resamplings are kept unchanged.}

\item{measures}{(\link[mlr3:Measure]{mlr3::Measure} or list of \link[mlr3:Measure]{mlr3::Measure})\cr
A single measure creates a \link{FSelectInstanceSingleCrit} and multiple measures a \link{FSelectInstanceMultiCrit}.
If \code{NULL}, default measure is used.}

\item{terminator}{(\link{Terminator})\cr
Stop criterion of the feature selection.}

\item{store_benchmark_result}{(\code{logical(1)})\cr
Store benchmark result in archive?}

\item{store_models}{(\code{logical(1)}).
Store models in benchmark result?}

\item{check_values}{(\code{logical(1)})\cr
Check the parameters before the evaluation and the results for
validity?}
}
\description{
Function to construct a \link{FSelectInstanceSingleCrit} or \link{FSelectInstanceMultiCrit}.
}
\section{Resources}{

\itemize{
\item \href{https://mlr3book.mlr-org.com/feature-selection.html#fs-wrapper}{book chapter} on feature selection.
\item \href{https://mlr-org.com/gallery/2020-09-14-mlr3fselect-basic/}{gallery post} on feature selection on the Titanic data set.
}
}

\examples{
# Feature selection on Palmer Penguins data set
task = tsk("penguins")
learner = lrn("classif.rpart")

# Construct feature selection instance
instance = fsi(
  task = task,
  learner = learner,
  resampling = rsmp("cv", folds = 3),
  measures = msr("classif.ce"),
  terminator = trm("evals", n_evals = 4)
)

# Choose optimization algorithm
fselector = fs("random_search", batch_size = 2)

# Run feature selection
fselector$optimize(instance)

# Subset task to optimal feature set
task$select(instance$result_feature_set)

# Train the learner with optimal feature set on the full data set
learner$train(task)

# Inspect all evaluated sets
as.data.table(instance$archive)
}
