% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterAnova.R
\name{FilterAnova}
\alias{FilterAnova}
\alias{mlr_filters_anova}
\title{ANOVA F-Test Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
ANOVA F-Test filter calling \code{\link[stats:aov]{stats::aov()}}. Note that this is
equivalent to a \eqn{t}-test for binary classification.

The filter value is \code{-log10(p)} where \code{p} is the \eqn{p}-value. This transformation
is necessary to ensure numerical stability for very small \eqn{p}-values.
}
\section{Construction}{
\preformatted{FilterAnova$new()
mlr_filters$get("anova")
flt("anova")
}
}

\examples{
task = mlr3::tsk("iris")
filter = flt("anova")
filter$calculate(task)
head(as.data.table(filter), 3)

# transform to p-value
10^(-filter$scores)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: 
\code{\link{FilterAUC}},
\code{\link{FilterCMIM}},
\code{\link{FilterCarScore}},
\code{\link{FilterCorrelation}},
\code{\link{FilterDISR}},
\code{\link{FilterImportance}},
\code{\link{FilterInformationGain}},
\code{\link{FilterJMIM}},
\code{\link{FilterJMI}},
\code{\link{FilterKruskalTest}},
\code{\link{FilterMIM}},
\code{\link{FilterMRMR}},
\code{\link{FilterNJMIM}},
\code{\link{FilterPerformance}},
\code{\link{FilterVariance}},
\code{\link{Filter}},
\code{\link{mlr_filters}}
}
\concept{Filter}
