% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDAInterpol.R
\name{mlr_pipeops_fda.interpol}
\alias{mlr_pipeops_fda.interpol}
\alias{PipeOpFDAInterpol}
\title{Interpolate Functional Columns}
\description{
Interpolate functional features (e.g. all individuals are observed at different time-points) to a common grid.
This is useful if you want to compare functional features across observations.
The interpolation is done using the \code{tf} package. See \code{\link[tf:tfd]{tfd()}} for details.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreprocSimple}}, as well as the following
parameters:
\itemize{
\item \code{grid} :: \code{character(1)} | numeric() \cr
The grid to use for interpolation.
If \code{grid} is numeric, it must be a sequence of values to use for the grid or a single value that
specifies the number of points to use for the grid, requires \code{left} and \code{right} to be specified in the latter case.
If \code{grid} is a character, it must be one of:
\itemize{
\item \code{"union"}: This option creates a grid based on the union of all argument points from the provided functional
features. This means that if the argument points across features are \(t_1, t_2, ..., t_n\), then the grid will
be the combined unique set of these points. This option is generally used when the argument points vary across
observations and a  common grid is needed for comparison or further analysis.
\item \code{"intersect"}: Creates a grid using the intersection of all argument points of a feature.
This grid includes only those points that are common across all functional features,
facilitating direct comparison on a shared set of points.
\item \code{"minmax"}: Generates a grid within the range of the maximum of the minimum argument points to the minimum of the
maximum argument points across features.
This bounded grid encapsulates the argument point range common to all features.
Note: For regular functional data this has no effect as all argument points are the same.
Initial value is \code{"union"}.
}
\item \code{method} :: \code{character(1)} \cr
Defaults to \code{"linear"}. One of:
\itemize{
\item \code{"linear"}: applies linear interpolation without extrapolation (see \code{\link[tf:tf_approx]{tf::tf_approx_linear()}}).
\item \code{"spline"}: applies cubic spline interpolation (see \code{\link[tf:tf_approx]{tf::tf_approx_spline()}}).
\item \code{"fill_extend"}: applies linear interpolation with constant extrapolation (see \code{\link[tf:tf_approx]{tf::tf_approx_fill_extend()}}).
\item \code{"locf"}: applies "last observation carried forward" interpolation (see \code{\link[tf:tf_approx]{tf::tf_approx_locf()}}).
\item \code{"nocb"}: applies "next observation carried backward" interpolation (see \code{\link[tf:tf_approx]{tf::tf_approx_nocb()}}).
}
\item \code{left} :: \code{numeric()} \cr
The left boundary of the window.
The window is specified such that the all values >=left and <=right are kept for the computations.
\item \code{right} :: \code{numeric()} \cr
The right boundary of the window.
}
}

\examples{
library(mlr3pipelines)

task = tsk("fuel")
pop = po("fda.interpol")
task_interpol = pop$train(list(task))[[1L]]
task_interpol$data()
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDAInterpol}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDAInterpol-new}{\code{PipeOpFDAInterpol$new()}}
\item \href{#method-PipeOpFDAInterpol-clone}{\code{PipeOpFDAInterpol$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAInterpol-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAInterpol-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAInterpol$new(id = "fda.interpol", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default \code{"fda.interpol"}.}

\item{\code{param_vals}}{(named \code{list})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAInterpol-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAInterpol-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAInterpol$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
