% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairness_prediction_density.R
\name{fairness_prediction_density}
\alias{fairness_prediction_density}
\title{Probability Density Plot}
\usage{
fairness_prediction_density(object, ...)
}
\arguments{
\item{object}{(\link{PredictionClassif} | \link{ResampleResult} | \link{BenchmarkResult})\cr
The binary class prediction object that will be evaluated.
If \link{PredictionClassif}, a \link{Task} is required.}

\item{...}{The arguments to be passed to methods, such as:
\itemize{
\item \code{task} (\link{TaskClassif})\cr
The data task that contains the protected column.
\item \code{type} \code{\link{character}}\cr
The plot type. Either \code{violin} or \code{density}.
}}
}
\value{
A 'ggplot2' object.
}
\description{
Visualizes per-subgroup densities across learners, task and class.
The plot is a combination of boxplot and violin plot.
The y-axis shows the levels in protected columns. And the x-axis shows the predicted probability.
The title for the plot will demonstrate which class for predicted probability.
}
\examples{
library(mlr3learners)

task = tsk("adult_train")$filter(1:500)
learner = lrn("classif.rpart", predict_type = "prob", cp = 0.001)
learner$train(task)

# For prediction
predictions = learner$predict(task)
fairness_prediction_density(predictions, task)

# For resampling
rr = resample(task, learner, rsmp("cv"))
fairness_prediction_density(rr)
}
