% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpReweighing.R
\name{mlr_pipeops_reweighing}
\alias{mlr_pipeops_reweighing}
\alias{PipeOpReweighingWeights}
\alias{PipeOpReweighingOversampling}
\title{Reweighing to balance disparate impact metric}
\format{
\link{R6Class} object inheriting from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Adjusts class balance and protected group balance in order to achieve fair(er) outcomes.
}
\section{PipeOpReweighingWeights}{

Adds a class weight column to the \link[mlr3:Task]{Task} that different \code{\link[mlr3:Learner]{Learner}}s
may be using. In case initial weights are present, those are multiplied with new weights.
Caution: Only fairness tasks are supported. Which means tasks need to have protected field.
\code{tsk$col_roles$pta}.
}

\section{PipeOpReweighingOversampling}{

Oversamples a \link[mlr3:Task]{Task} for more balanced ratios in subgroups and protected groups.
Can be used if a learner does not support weights.
Caution: Only fairness tasks are supported. Which means tasks need to have protected field.
\code{tsk$col_roles$pta}.
}

\section{Construction}{
\preformatted{PipeOpReweighing*$new(id = "reweighing", param_vals = list())
}
\itemize{
\item \code{id} (\code{character(1)}).
\item \code{param_vals} (\code{list()})
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \link{PipeOpTaskPreproc}. Instead of a \code{\link[mlr3:Task]{Task}}, a
\link[mlr3:TaskClassif]{TaskClassif} is used as input and output during training and prediction.

The output during training is the input \link[mlr3:Task]{Task} with added weights column according
to target class. The output during prediction is the unchanged input.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \link{PipeOpTaskPreproc}.
}

\section{Parameters}{

\itemize{
\item \code{alpha} (\code{numeric()}): A number between 0 (no debiasing) and 1 (full debiasing).
}
}

\section{Internals}{

Introduces, or overwrites, the "weights" column in the \link[mlr3:Task]{Task}.
However, the \link[mlr3:Learner]{Learner} method needs to
respect weights for this to have an effect.

The newly introduced column is named \code{reweighing.WEIGHTS}; there will be a naming conflict if this
column already exists and is \emph{not} a weight column itself.
}

\section{Fields}{

Only fields inherited from \link{PipeOpTaskPreproc}/\code{\link{PipeOp}}.
}

\section{Methods}{

Methods inherited from \link{PipeOpTaskPreproc}/\code{\link{PipeOp}}.
}

\examples{
library(mlr3pipelines)

reweighing = po("reweighing_wts")
learner_po = po("learner", learner = lrn("classif.rpart"))

data = tsk("adult_train")
graph = reweighing \%>>\% learner_po
glrn = GraphLearner$new(graph)
glrn$train(data)
tem = glrn$predict(data)
tem$confusion
}
\references{
Kamiran, Faisal, Calders, Toon (2012).
\dQuote{Data preprocessing techniques for classification without discrimination.}
\emph{Knowledge and Information Systems}, \bold{33}(1), 1--33.
}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other PipeOps: 
\code{\link{mlr_pipeops_equalized_odds}},
\code{\link{mlr_pipeops_explicit_pta}}
}
\concept{PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{PipeOpReweighingWeights}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpReweighingWeights$new()}}
\item \href{#method-clone}{\code{PipeOpReweighingWeights$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this [R6][R6::R6Class][PipeOp] R6 class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpReweighingWeights$new(id = "reweighing_wts", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
The PipeOps identifier in the PipeOps library.}

\item{\code{param_vals}}{\code{list} \cr
The parameter values to be set.
\itemize{
\item alpha: controls the proportion between initial weight (1 if non existing) and reweighing weight.
Defaults to 1.
Here is how it works:
new_weight = (1 - alpha) * 1 + alpha x reweighing_weight
final_weight = old_weight * new_weight
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpReweighingWeights$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{PipeOpReweighingOversampling}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpReweighingOversampling$new()}}
\item \href{#method-clone}{\code{PipeOpReweighingOversampling$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpReweighingOversampling$new(id = "reweighing_os", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{`character' \cr
The PipeOp's id.}

\item{\code{param_vals}}{`list' \cr
A list of parameter values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpReweighingOversampling$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
