% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_operations.R
\name{groupdiff_tau}
\alias{groupdiff_tau}
\alias{groupdiff_absdiff}
\alias{groupdiff_diff}
\title{Groupwise Operations}
\usage{
groupdiff_tau(x)

groupdiff_absdiff(x)

groupdiff_diff(x)
}
\arguments{
\item{x}{(\code{numeric()})\cr
Measured performance in group 1, 2, ...}
}
\value{
A single \code{numeric}.
}
\description{
\code{groupdiff_tau()} computes \eqn{min(x/y, y/x)}, i.e. the smallest symmetric ratio between \eqn{x} and eqn{y}
that is smaller than 1. If \eqn{x} is a vector, the symmetric ratio between all
elements in \eqn{x} is computed.

\code{groupdiff_absdiff()} computes \eqn{max(abs(x-y, y-x))}, i.e. the smallest absolute difference
between \eqn{x} and \eqn{y}.
If \eqn{x} is a vector, the symmetric absolute difference between all elements in \eqn{x} is computed.
}
\examples{
groupdiff_tau(1:3)
groupdiff_diff(1:3)
groupdiff_absdiff(1:3)
}
