% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_resamplings.R
\docType{data}
\name{mlr_resamplings}
\alias{mlr_resamplings}
\title{Dictionary of Resampling Strategies}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{Resampling}.
Each resampling has an associated help page, see \code{mlr_resamplings_[id]}.

This dictionary can get populated with additional resampling strategies by add-on packages.

For a more convenient way to retrieve and construct resampling strategies, see \code{\link[=rsmp]{rsmp()}}/\code{\link[=rsmps]{rsmps()}}.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict, ..., objects = FALSE)}\cr
\link[mlr3misc:Dictionary]{mlr3misc::Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a \code{\link[data.table:data.table]{data.table::data.table()}} with columns "key", "label", "params", and "iters".
If \code{objects} is set to \code{TRUE}, the constructed objects are returned in the list column named \code{object}.
}
}

\examples{
as.data.table(mlr_resamplings)
mlr_resamplings$get("cv")
rsmp("subsampling")
}
\seealso{
Sugar functions: \code{\link[=rsmp]{rsmp()}}, \code{\link[=rsmps]{rsmps()}}

Other Dictionary: 
\code{\link{mlr_learners}},
\code{\link{mlr_measures}},
\code{\link{mlr_task_generators}},
\code{\link{mlr_tasks}}

Other Resampling: 
\code{\link{Resampling}},
\code{\link{mlr_resamplings_bootstrap}},
\code{\link{mlr_resamplings_custom_cv}},
\code{\link{mlr_resamplings_custom}},
\code{\link{mlr_resamplings_cv}},
\code{\link{mlr_resamplings_holdout}},
\code{\link{mlr_resamplings_insample}},
\code{\link{mlr_resamplings_loo}},
\code{\link{mlr_resamplings_repeated_cv}},
\code{\link{mlr_resamplings_subsampling}}
}
\concept{Dictionary}
\concept{Resampling}
\keyword{datasets}
