% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateCritDifferences.R
\name{plotCritDifferences}
\alias{plotCritDifferences}
\title{Plot critical differences for a selected measure.}
\usage{
plotCritDifferences(obj, baseline = NULL)
}
\arguments{
\item{obj}{[\code{critDifferencesData}]
Result of \link{generateCritDifferencesData} function.}

\item{baseline}{[\code{character(1)}]: [\code{learner.id}] \cr
Overwrites baseline from \link{generateCritDifferencesData}!\cr
Select a [\code{learner.id} as baseline for the critical difference
diagram, the critical difference will be positioned arround this learner.
Defaults to best performing algorithm.}
}
\value{
ggplot2 plot object.
}
\description{
Plots a critical-differences diagram for all classifiers and
a selected measure. If a baseline is selected for the Bonferroni-Dunn
test, the critical difference interval will be positioned arround the baseline.
If not, the best performing algorithm will be chosen as baseline.
}
\examples{
lrns = list(makeLearner("classif.nnet"), makeLearner("classif.rpart"))
tasks = list(iris.task, sonar.task)
rdesc = makeResampleDesc("CV", iters = 2L)
meas = list(acc, mmce)
res = benchmark(lrns, tasks, rdesc, meas)
r = generateCritDifferencesData(res, mmce, p.value = 0.3, test = "bd")
plotCritDifferences(r)

}
\references{
Janez Demsar, Statistical Comparisons of Classifiers over Multiple Data Sets,
JMLR, 2006
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotRankMatrixAsBar}}

Other plot: \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotRankMatrixAsBar}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

