% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Learner_operators.R
\name{getLearnerShortName}
\alias{getLearnerShortName}
\title{Get the short name of the learner.}
\usage{
getLearnerShortName(learner)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}
}
\value{
(\code{character(1)}).
}
\description{
For an ordinary learner simply its short name is returned.
For wrapped learners, the wrapper id is successively attached to the short
name of the base learner. E.g: \dQuote{rf.bagged.imputed}
}
\seealso{
Other learner: \code{\link{LearnerProperties}},
  \code{\link{getClassWeightParam}},
  \code{\link{getHyperPars}}, \code{\link{getLearnerId}},
  \code{\link{getLearnerNote}},
  \code{\link{getLearnerPackages}},
  \code{\link{getLearnerParVals}},
  \code{\link{getLearnerParamSet}},
  \code{\link{getLearnerPredictType}},
  \code{\link{getLearnerType}}, \code{\link{getParamSet}},
  \code{\link{helpLearnerParam}},
  \code{\link{helpLearner}}, \code{\link{makeLearners}},
  \code{\link{makeLearner}}, \code{\link{removeHyperPars}},
  \code{\link{setHyperPars}}, \code{\link{setId}},
  \code{\link{setLearnerId}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}
}
\concept{learner}
