% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeClassifTask}
\alias{ClassifTask}
\alias{CostSensTask}
\alias{RegrTask}
\alias{SupervisedTask}
\alias{SurvTask}
\alias{makeClassifTask}
\alias{makeCostSensTask}
\alias{makeRegrTask}
\alias{makeSurvTask}
\title{Create a classification, regression, survival or cost-sensitive classification task.}
\usage{
makeClassifTask(id, data, target, weights = NULL, blocking = NULL, positive,
  fixup.data = "warn", check.data = TRUE)

makeCostSensTask(id, data, costs, blocking = NULL, fixup.data = "warn",
  check.data = TRUE)

makeRegrTask(id, data, target, weights = NULL, blocking = NULL,
  fixup.data = "warn", check.data = TRUE)

makeSurvTask(id, data, target, surv.type = "right", weights = NULL,
  blocking = NULL, fixup.data = "warn", check.data = TRUE)
}
\arguments{
\item{id}{[\code{character(1)}]\cr
Id string for object.
Default is the name of R variable passed to \code{data}.}

\item{data}{[\code{data.frame}]\cr
A data frame containing the features and target variable(s).}

\item{target}{[\code{character(1)} | \code{character(2)}]\cr
Name of the target variable.
For survival analysis these are the names of the survival time and event columns,
so it has length 2.}

\item{costs}{[\code{data.frame}]\cr
A numeric matrix or data frame containing the costs of misclassification.
We assume the general case of observation specific costs.
This means we have n rows, corresponding to the observations, in the same order as \code{data}.
The columns correspond to classes and their names are the class labels
(if unnamed we use y1 to yk as labels).
Each entry (i,j) of the matrix specifies the cost of predicting class j
for observation i.}

\item{weights}{[\code{numeric}]\cr
Optional, non-negative case weight vector to be used during fitting.
Cannot be set for cost-sensitive learning.
Default is \code{NULL} which means no (= equal) weights.}

\item{blocking}{[\code{factor}]\cr
An optional factor of the same length as the number of observations.
Observations with the same blocking level \dQuote{belong together}.
Specifically, they are either put all in the training or the test set
during a resampling iteration.
Default is \code{NULL} which means no blocking.}

\item{positive}{[\code{character(1)}]\cr
Positive class for binary classification.
Default is the first factor level of the target attribute.}

\item{fixup.data}{[\code{character(1)}]\cr
Should some basic cleaning up of data be performed?
Currently this means removing empty factor levels for the columns.
Possible coices are:
\dQuote{no} = Don't do it.
\dQuote{warn} = Do it but warn about it.
\dQuote{quiet} = Do it but keep silent.
Default is \dQuote{warn}.}

\item{check.data}{[\code{logical(1)}]\cr
Should sanity of data be checked initially at task creation?
You should have good reasons to turn this off (one might be speed).
Default is \code{TRUE}}

\item{surv.type}{[\code{character(1)}]\cr
Survival type. Allowed are \dQuote{right} (default), \dQuote{left} and \dQuote{interval2}.
See \code{\link[survival]{Surv}} for details.}
}
\value{
[\code{\link{SupervisedTask}}].
}
\description{
The task encapsulates the data and specifies - through its subclasses -
the type of the task.
It also contains a description object detailing further aspects of the data.

Useful operators are: \code{\link{getTaskFormula}}, \code{\link{getTaskFormulaAsString}},
\code{\link{getTaskFeatureNames}}, \code{\link{getTaskData}}, \code{\link{getTaskTargets}},
\code{\link{subsetTask}}.

Object members:
\describe{
\item{env [\code{environment}]}{Environment where data for the task are stored.
  Use \code{\link{getTaskData}} in order to access it.}
\item{weights [\code{numeric}]}{See argument above. \code{NULL} if not present.}
\item{blocking [\code{factor}]}{See argument above. \code{NULL} if not present.}
\item{task.desc [\code{\link{TaskDesc}}]}{Encapsulates further information about the task.}
}
}
\examples{
library(mlbench)
data(BostonHousing)
data(Ionosphere)

makeClassifTask(data = iris, target = "Species")
makeRegrTask(data = BostonHousing, target = "medv")
# an example of a classification task with more than those standard arguments:
blocking = factor(c(rep(1, 51), rep(2, 300)))
makeClassifTask(id = "myIonosphere", data = Ionosphere, target = "Class",
  positive = "good", blocking = blocking)
}

