% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{mlflow_rfunc_predict}
\alias{mlflow_rfunc_predict}
\title{Predict using RFunc MLflow Model}
\usage{
mlflow_rfunc_predict(model_path, run_uuid = NULL, input_path = NULL,
  output_path = NULL, data = NULL, restore = FALSE)
}
\arguments{
\item{model_path}{The path to the MLflow model, as a string.}

\item{run_uuid}{Run ID of run to grab the model from.}

\item{input_path}{Path to 'JSON' or 'CSV' file to be used for prediction.}

\item{output_path}{'JSON' or 'CSV' file where the prediction will be written to.}

\item{data}{Data frame to be scored. This can be utilized for testing purposes and can only
be specified when `input_path` is not specified.}

\item{restore}{Should \code{mlflow_restore_snapshot()} be called before serving?}
}
\description{
Predict using an RFunc MLflow Model from a file or data frame.
}
\examples{
\dontrun{
library(mlflow)

# save simple model which roundtrips data as prediction
mlflow_save_model(function(df) df, "mlflow_roundtrip")

# save data as json
jsonlite::write_json(iris, "iris.json")

# predict existing model from json data
mlflow_rfunc_predict("mlflow_roundtrip", "iris.json")
}

}
