% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerRates}
\alias{mizerRates}
\title{Get all rates needed to project standard mizer model}
\usage{
mizerRates(params, n, n_pp, n_other, t = 0, effort, rates_fns, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{effort}{The effort for each fishing gear}

\item{rates_fns}{Named list of the functions to call to calculate the rates.
Note that this list holds the functions themselves, not their names.}

\item{...}{Unused}
}
\value{
List of rates.
}
\description{
Calls other rate functions in sequence and collects the results in a list.
}
\details{
By default this function returns a list with the following components:
\itemize{
\item encounter from \code{\link[=mizerEncounter]{mizerEncounter()}}
\item feeding_level from \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}}
\item e from \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}
\item e_repro from \code{\link[=mizerERepro]{mizerERepro()}}
\item e_growth from \code{\link[=mizerEGrowth]{mizerEGrowth()}}
\item pred_rate from \code{\link[=mizerPredRate]{mizerPredRate()}}
\item pred_mort from \code{\link[=mizerPredMort]{mizerPredMort()}}
\item f_mort from \code{\link[=mizerFMort]{mizerFMort()}}
\item mort from \code{\link[=mizerMort]{mizerMort()}}
\item rdi from \code{\link[=mizerRDI]{mizerRDI()}}
\item rdd from \code{\link[=BevertonHoltRDD]{BevertonHoltRDD()}}
\item resource_mort from \code{\link[=mizerResourceMort]{mizerResourceMort()}}
}
However you can replace any of these rate functions by your own rate
function if you wish, see \code{\link[=setRateFunction]{setRateFunction()}} for details.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
