% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getYieldGear}
\alias{getYieldGear}
\title{Calculate the rate at which biomass of each species is fished by each gear}
\usage{
getYieldGear(object)
}
\arguments{
\item{object}{An object of class \code{MizerParams} or \code{MizerSim}.}
}
\value{
If called with a MizerParams object, an array (gear x species) with
the yield rate in grams per year from each gear for each species in the
model. If called with a MizerSim object, an array (time x gear x species)
containing the yield rate at each time step.
}
\description{
This yield rate is given in grams per year. It is calculated at each time
step saved in the MizerSim object.
}
\details{
For details of how the yield rate is defined see the help page of
\code{\link[=getYield]{getYield()}}.
}
\examples{
yield <- getYieldGear(NS_sim)
yield["1972", "Herring", "Herring"]
# (In this example MizerSim object each species was set up with its own gear)
}
\seealso{
\code{\link[=getYield]{getYield()}}

Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getGrowthCurves}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYield}()}
}
\concept{summary functions}
\concept{summary_function}
