% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getRates}
\alias{getRates}
\title{Get all rates}
\usage{
getRates(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  effort,
  t = 0,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{effort}{The effort for each fishing gear}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{...}{Unused}
}
\description{
Calls other rate functions in sequence and collects the results in a list.
}
\details{
By default this function returns a list with the following components:
\itemize{
\item encounter from \code{\link[=mizerEncounter]{mizerEncounter()}}
\item feeding_level from \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}}
\item e from \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}
\item e_repro from \code{\link[=mizerERepro]{mizerERepro()}}
\item e_growth from \code{\link[=mizerEGrowth]{mizerEGrowth()}}
\item pred_rate from \code{\link[=mizerPredRate]{mizerPredRate()}}
\item pred_mort from \code{\link[=mizerPredMort]{mizerPredMort()}}
\item f_mort from \code{\link[=mizerFMort]{mizerFMort()}}
\item mort from \code{\link[=mizerMort]{mizerMort()}}
\item rdi from \code{\link[=mizerRDI]{mizerRDI()}}
\item rdd from \code{\link[=BevertonHoltRDD]{BevertonHoltRDD()}}
\item resource_mort from \code{\link[=mizerResourceMort]{mizerResourceMort()}}
}
However you can replace any of these rate functions by your own rate
function if you wish, see \code{\link[=setRateFunction]{setRateFunction()}} for details.
}
\examples{
rates <- getRates(NS_params)
names(rates)
identical(rates$encounter, getEncounter(NS_params))
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
