% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMaxIntakeRate.R
\name{setMaxIntakeRate}
\alias{setMaxIntakeRate}
\alias{getMaxIntakeRate}
\title{Set maximum intake rate}
\usage{
setMaxIntakeRate(
  params,
  intake_max = NULL,
  comment_intake_max = "set manually",
  ...
)

getMaxIntakeRate(params)
}
\arguments{
\item{params}{MizerParams}

\item{intake_max}{Optional. An array (species x size) holding the maximum
intake rate for each species at size. If not supplied, a default is set as
described in the section "Setting maximum intake rate".}

\item{comment_intake_max}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A string describing how the value for 'intake_max' was obtained. This is
ignored if 'intake_max' is not supplied or already has a comment
attribute.}

\item{...}{Unused}
}
\value{
A \code{MizerParams} object with updated maximum intake rate. Because
of the way the R language works, \code{setMaxIntakeRate()} does not make the
changes to the params object that you pass to it but instead returns a new
params object. So to affect the change you call the function in the form
\code{params <- setMaxIntakeRate(params, ...)}.
}
\description{
Set maximum intake rate
}
\section{Setting maximum intake rate}{

The maximum intake rate \eqn{h_i(w)} of an individual of species \eqn{i} and
weight \eqn{w} determines the feeding level, calculated with
\code{\link[=getFeedingLevel]{getFeedingLevel()}}. It is measured in grams/year.

If the \code{intake_max} argument is not supplied, then the maximum intake
rate is set to \deqn{h_i(w) = h_i w^{n_i}.}
The values of \eqn{h_i} (the maximum intake rate of an individual of size 1
gram) and \eqn{n_i} (the allometric exponent for the intake rate) are taken
from the \code{h} and \code{n} columns in the species parameter dataframe. If
the \code{h} column is not supplied in the species parameter dataframe, it is
calculated by the \code{\link[=get_h_default]{get_h_default()}} function, using \code{f0} and
the \code{k_vb} column, if they are supplied.

If \eqn{h_i} is set to \code{Inf}, fish will consume all encountered food.
}

\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{resource_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
