% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getYieldGear}
\alias{getYieldGear}
\title{Calculate the yearly yield per gear and species}
\usage{
getYieldGear(sim)
}
\arguments{
\item{sim}{An object of class \code{MizerSim}.}
}
\value{
An array (time x gear x species) containing the yearly yield in
grams.
}
\description{
Calculates the yearly yield (biomass fished per year) per gear and species at
each simulation time step.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
getYieldGear(sim)
}
}
\seealso{
\code{\link[=getYield]{getYield()}}

Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getGrowthCurves}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYield}()}
}
\concept{summary functions}
\concept{summary_function}
