% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getRDI}
\alias{getRDI}
\title{Get density independent rate of egg production}
\usage{
getRDI(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  t = 0,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{...}{Unused}
}
\value{
A numeric vector the length of the number of species.
}
\description{
Calculates the density-independent rate of total egg production \eqn{R_{di}}{R_di}
(units 1/year) before density dependence, by species.
}
\details{
This rate is obtained by taking the per capita rate \eqn{E_r(w)\psi(w)} at
which energy is invested in reproduction, as calculated by \code{\link[=getERepro]{getERepro()}},
multiplying it by the number of individuals\eqn{N(w)} and integrating over all sizes
\eqn{w} and then multiplying by the reproductive efficiency \eqn{\epsilon}
and dividing by the egg size \code{w_min}, and by a factor of two to account for
the two sexes:
\deqn{R_{di} = \frac{\epsilon}{2 w_{min}} \int N(w)  E_r(w) \psi(w) \, dw}{R_di = (\epsilon/(2 w_min)) \int N(w)  E_r(w) \psi(w) dw}

Used by \code{\link[=getRDD]{getRDD()}} to calculate the actual, density dependent rate.
See \code{\link[=setReproduction]{setReproduction()}} for more details.
}
\section{Your own reproduction function}{

By default \code{\link[=getRDI]{getRDI()}} calls \code{\link[=mizerRDI]{mizerRDI()}}. However you can
replace this with your own alternative reproduction function. If
your function is called \code{"myRDI"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "RDI", "myRDI")
}

Your function will then be called instead of \code{\link[=mizerRDI]{mizerRDI()}}, with the
same arguments. For an example of an alternative reproduction function
see \code{constantEggRDI()}.
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the density-independent reproduction rate at a particular time step
getRDI(params, n = N(sim)[15, , ], n_pp = NResource(sim)[15, ], t = 15)
}
}
\seealso{
\code{\link[=getRDD]{getRDD()}}

Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
