% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_dynamics.R
\name{resource_semichemostat}
\alias{resource_semichemostat}
\title{Project resource using semichemostat model}
\usage{
resource_semichemostat(params, n, n_pp, n_other, rates, t, dt, ...)
}
\arguments{
\item{params}{A \link{MizerParams} object}

\item{n}{A matrix of species abundances (species x size)}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list with the abundances of other components}

\item{rates}{A list of rates as returned by \code{\link[=mizerRates]{mizerRates()}}}

\item{t}{The current time}

\item{dt}{Time step}

\item{...}{Unused}
}
\value{
Vector containing resource spectrum at next timestep
}
\description{
Project resource using semichemostat model
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter,
                                resource_dynamics = "resource_semichemostat")
}
}
