% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getGrowthCurves}
\alias{getGrowthCurves}
\title{Get growth curves giving weight as a function of age}
\usage{
getGrowthCurves(object, species, max_age = 20, percentage = FALSE)
}
\arguments{
\item{object}{MizerSim or MizerParams object. If given a
\linkS4class{MizerSim} object, uses the growth rates at the final time of a
simulation to calculate the size at age. If given a
\linkS4class{MizerParams} object, uses the initial growth rates instead.}

\item{species}{Name or vector of names of the species to be included. By
default all species are included.}

\item{max_age}{The age up to which to run the growth curve. Default is 20.}

\item{percentage}{Boolean value. If TRUE, the size is given as a percentage
of the maximal size.}
}
\value{
An array (species x age) containing the weight in grams.
}
\description{
Get growth curves giving weight as a function of age
}
\examples{
\dontrun{
params <- suppressMessages(newMultispeciesParams(NS_species_params_gears, inter))
getGrowthCurves(params)
sim <- project(params, effort=1, t_max = 20, t_save = 2, progress_bar = FALSE)
getGrowthCurves(sim, max_age = 24)
}
}
\seealso{
Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYieldGear}()},
\code{\link{getYield}()}
}
\concept{summary functions}
