% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getEGrowth}
\alias{getEGrowth}
\title{Get energy rate available for growth}
\usage{
getEGrowth(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  e_repro = getERepro(params, n = n, n_pp = n_pp, n_other = n_other),
  e = getEReproAndGrowth(params, n = n, n_pp = n_pp, n_other = n_other)
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{e_repro}{The energy available for reproduction (optional, although if
specified, e must also be specified). A matrix of size no. species x no.
size bins. If not supplied, is calculated internally using
\code{\link[=getERepro]{getERepro()}}.}

\item{e}{The energy available for reproduction and growth (optional, although
if specified, e_repro must also be specified). A matrix of size no.
species x no. size bins. If not supplied, is calculated internally using
\code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}.}
}
\value{
A two dimensional array (prey species x prey size)
}
\description{
Calculates the energy rate \eqn{g_i(w)} (grams/year) available by species and
size for growth after metabolism, movement and reproduction have been
accounted for. Used by \code{\link[=project]{project()}} for performing simulations.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getEGrowth(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
\code{\link[=getERepro]{getERepro()}}, \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}

Other rate functions: 
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
