% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\docType{methods}
\name{getMeanMaxWeight}
\alias{getMeanMaxWeight}
\alias{getMeanMaxWeight,MizerSim-method}
\title{Calculate the mean maximum weight of the community}
\usage{
getMeanMaxWeight(object, ...)

\S4method{getMeanMaxWeight}{MizerSim}(object,
  species = 1:nrow(object@params@species_params), measure = "both", ...)
}
\arguments{
\item{object}{An object of class \code{MizerSim}.}

\item{...}{Other arguments for the \code{getN} and \code{getBiomass} methods such as \code{min_w}, \code{max_w} \code{min_l} and \code{max_l}.}

\item{species}{numeric or character vector of species to include in the calculation.}

\item{measure}{The measure to return. Can be 'numbers', 'biomass' or 'both'}
}
\value{
A matrix or vector containing the mean maximum weight of the community through time
}
\description{
Calculates the mean maximum weight of the community through time. This can be
calculated by numbers or biomass. The calculation is the sum of the w_inf *
abundance of each species, divided by the total abundance community, where
abundance is either in biomass or numbers. You can specify minimum and
maximum weight or length range for the species. Lengths take precedence over
weights (i.e. if both min_l and min_w are supplied, only min_l will be used).
You can also specify the species to be used in the calculation.

Calculate the mean maximum weight of the community from a \code{MizerSim} object.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=10)
getMeanMaxWeight(sim)
getMeanMaxWeight(sim, species=c("Herring","Sprat","N.pout"))
getMeanMaxWeight(sim, min_w = 10, max_w = 5000)
}
}
