% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getESpawning}
\alias{getESpawning}
\alias{getESpawning,MizerParams,matrix,numeric,matrix-method}
\alias{getESpawning,MizerParams,matrix,numeric,missing-method}
\title{Get energy rate available for reproduction}
\usage{
getESpawning(object, n, n_pp, e)

\S4method{getESpawning}{MizerParams,matrix,numeric,matrix}(object, n, n_pp, e)

\S4method{getESpawning}{MizerParams,matrix,numeric,missing}(object, n, n_pp)
}
\arguments{
\item{object}{A \code{MizerParams} object.}

\item{n}{A matrix of species abundance (species x size).}

\item{n_pp}{A vector of the background abundance by size.}

\item{e}{The energy available for reproduction and growth (optional). A
matrix of size no. species x no. size bins. If not supplied, is calculated
internally using the \code{getEReproAndGrowth()} method.}
}
\value{
A two dimensional array (prey species x prey size)
}
\description{
Calculates the energy rate available by species and size for reproduction
after metabolism and movement have been accounted for:
\eqn{\psi_i(w)E_{r.i}(w)}. Used by the \code{project} method for performing
simulations.

\code{getESpawning} method with \code{e} argument.

\code{getESpawning} method without \code{e} argument.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getESpawning(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
\code{\link{project}} and \code{\link{getEReproAndGrowth}}.
}
