% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getRDD}
\alias{getRDD}
\alias{getRDD,MizerParams,matrix,numeric,matrix-method}
\alias{getRDD,MizerParams,matrix,numeric,missing-method}
\title{Get density dependent recruitment}
\usage{
getRDD(object, n, n_pp, rdi, ...)

\S4method{getRDD}{MizerParams,matrix,numeric,matrix}(object, n, n_pp, rdi,
  sex_ratio = 0.5)

\S4method{getRDD}{MizerParams,matrix,numeric,missing}(object, n, n_pp,
  sex_ratio = 0.5)
}
\arguments{
\item{object}{An \code{MizerParams} object}

\item{n}{A matrix of species abundance (species x size)}

\item{n_pp}{A vector of the background abundance by size}

\item{rdi}{A matrix of density independent recruitment (optional) with
dimensions no. sp x 1. If not specified rdi is calculated internally using
the \code{\link{getRDI}} method.}

\item{...}{Other arguments (currently unused).}

\item{sex_ratio}{Proportion of the population that is female. Default value
is 0.5}
}
\value{
A numeric vector the length of the number of species.
}
\description{
Calculates the density dependent recruitment (total egg production) \eqn{R_i}
for each species. This is the flux entering the smallest size class of each
species. The density dependent recruitment is the density independent
recruitment after it has been put through the density dependent
stock-recruitment relationship function. This method is used by the
\code{project} method for performing simulations.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getRDD(params,sim@n[21,,],sim@n_pp[21,])
}
}
