\name{mint.pca}
\encoding{UTF-8}
\alias{mint.pca}

\title{P-integration with Principal Component Analysis}


\description{Function to integrate and combine multiple independent studies measured on the same variables or predictors  (P-integration) using a multigroup Principal Component Analysis.
}

\usage{
mint.pca(X,
ncomp = 2,
study,
scale = TRUE,
tol = 1e-06,
max.iter = 100
)

}

\arguments{
\item{X}{numeric matrix of predictors combining multiple independent studies on the same set of predictors. \code{NA}s are allowed.}
\item{ncomp}{Number of components to include in the model (see Details). Default to 2}
\item{study}{factor indicating the membership of each sample to each of the studies being combined}
\item{scale}{boleean. If scale = TRUE, each block is standardized
to zero means and unit variances. Default = \code{TRUE}.}
\item{tol}{Convergence stopping value.}
\item{max.iter}{integer, the maximum number of iterations.}

}


\details{
\code{mint.pca} fits a vertical PCA model with \code{ncomp} components in which several independent studies measured on the same variables are integrated.  The \code{study} factor indicates the membership of each sample in each study. We advise to only combine studies with more than 3 samples as the function performs internal scaling per study.

Missing values are handled by being disregarded during the cross product computations in the algorithm without having to delete rows with missing data. Alternatively, missing data can be imputed prior using the  \code{nipals} function.

Useful graphical outputs are available, e.g. \code{\link{plotIndiv}}, \code{\link{plotLoadings}}, \code{\link{plotVar}}.
}

\value{
\code{mint.pca} returns an object of class \code{"mint.pca", "pca"}, a list
that contains the following components:

\item{X}{the centered and standardized original predictor matrix.}
\item{ncomp}{the number of components included in the model.}
\item{study}{The study grouping factor}
\item{sdev}{the eigenvalues of the covariance/correlation matrix, though the calculation is actually
done with the singular values of the data matrix or by using NIPALS.}
\item{center, scale}{the centering and scaling used, or \code{FALSE}.}
\item{rotation}{the matrix of variable loadings (i.e., a matrix whose columns contain the eigenvectors).}
\item{loadings}{same as 'rotation' to keep the mixOmics spirit}
\item{x}{the value of the rotated data (the centred (and scaled if requested) data
multiplied by the rotation/loadings matrix), also called the principal components.}
\item{variates}{same as 'x' to keep the mixOmics spirit}
\item{explained_variance}{explained variance from the multivariate model, used for plotIndiv}
\item{names}{list containing the names to be used for individuals and variables.}
}

\references{
Rohart F, Eslami A, Matigian, N, Bougeard S, Le Cao K-A (2017). MINT: A multivariate integrative approach to identify a reproducible biomarker signature across multiple experiments and platforms. BMC Bioinformatics 18:128.

Eslami, A., Qannari, E. M., Kohler, A., and Bougeard, S. (2014). Algorithms for multi-group PLS. J. Chemometrics, 28(3), 192-201.
}

\author{Florian Rohart, Kim-Anh Le Cao}

\seealso{\code{\link{spls}}, \code{\link{summary}},
\code{\link{plotIndiv}}, \code{\link{plotVar}}, \code{\link{predict}}, \code{\link{perf}}, \code{\link{mint.spls}}, \code{\link{mint.plsda}}, \code{\link{mint.splsda}} and http://www.mixOmics.org/mixMINT for more details.}

\examples{
data(stemcells)

res = mint.pca(X = stemcells$gene, ncomp = 3,
study = stemcells$study)

plotIndiv(res, group = stemcells$celltype, legend=TRUE)

}

\keyword{regression}
\keyword{multivariate}
