% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift.R
\name{shift}
\alias{shift}
\title{Compute lagged or leading values of a vector}
\usage{
shift(x, n = 1, fill = NA, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{n}{a numeric value denoting the offset by which to lag (positive
value) or lead (negative value), e.g. \code{n = 1} (default)
returns lag-1 values, and  \code{n = -1} returns lead-1 values of
the vector specified in 'x'.}

\item{fill}{a numeric value or \code{NA} (default) used to pad \code{x} back
to its original size after the lag or lead has been applied.}

\item{as.na}{a numeric vector indicating user-defined missing values, i.e.
these values are converted to \code{NA} before computing lagged
or leading values of the vector.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector  with the same length containing lagged or leading values.
}
\description{
This function computes lagged or leading values of a vector by a specified
number of observations. By default, the function returns lag-1 values of the
vector specified in the argument 'x'.
}
\note{
This function is a modified copy of the \code{lag()} and \code{lead()} functions
in the \pkg{dplyr} package by Wickham et al. (2023).
}
\examples{
#--------------------------------------
# Lagged values

# Lag-1 values
shift(1:10)

# Lag-2 values
shift(1:10, n = 2)

# Value -99 to pad 'x'
shift(1:10, fill = -99)

#--------------------------------------
# Leading values

# Lead-1 values
shift(1:10, n = -1)

# Lead-2 values
shift(1:10, n = -2)
}
\references{
Wickham H, Francois R, Henry L, Müller K, & Vaughan D (2023). \emph{dplyr: A grammar
of data manipulation}. R package version 1.1.3, <https://CRAN.R-project.org/package=dplyr>.
}
\seealso{
\code{\link{center}}, \code{\link{rec}}, \code{\link{dummy.c}}, \code{\link{item.reverse}}.
}
\author{
Hadley Wickham, Romain Francois, Lionel Henry, and Kirill Müller, and Davis Vaughan.
}
