% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.descript.R
\name{print.descript}
\alias{print.descript}
\title{Print descript object}
\usage{
\method{print}{descript}(x, print = x$args$print, mat = x$args$mat,
      sort.var = x$args$sort.var, digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{descript} object.}

\item{print}{a character vector indicating which statistical measures to be printed on the console,
i.e. \code{n} (number of observations), \code{nNA} (number of missing values),
\code{pNA} (percentage of missing values), \code{m} (arithmetic mean), \code{var} (variance),
\code{sd} (standard deviation), \code{med} (median),\code{min} (minimum),
\code{p25} (25th percentile, first quartile), \code{p75} (75th percentile, third quartile),
\code{max} (maximum),  \code{range} (range), \code{iqr} (interquartile range),
\code{skew} (skewness), and \code{kurt} (excess kurtosis).}

\item{mat}{logical: if \code{TRUE}, output by a grouping variable is shown in a matrix.}

\item{sort.var}{logical: if \code{TRUE}, output is sorted by variables.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{descript} object
}
\examples{
dat <- data.frame(group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
                  x1 = c(3, 1, 4, 2, 5, 3, 2, 4, NA, 4),
                  x2 = c(4, NA, 3, 6, 3, 7, 2, 7, 5, 1),
                  x3 = c(7, 8, 5, 6, 4, NA, 8, NA, 6, 5))

# Descriptive statistics for x1
dat.descript <- descript(dat$x1, output = FALSE)

# Print descript object with 3 digits
print(dat.descript, digits = 3)
}
\seealso{
\code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
