% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixdist.R
\name{mixdist}
\alias{mixdist}
\alias{mixdist.dist}
\alias{mixdist.default}
\title{Creates an Object Representing Mixture Distribution}
\usage{
mixdist(..., weights)

\method{mixdist}{dist}(..., weights)

\method{mixdist}{default}(dist, params, weights, ...)
}
\arguments{
\item{...}{distribution objects.}

\item{weights}{vector of weights for the components.}

\item{dist}{vector of distribution names.}

\item{params}{list of parameters for each component.}
}
\value{
Object of class mixdist.
}
\description{
\code{mixdist} creates an object which represents the mixture distribution.
}
\details{
A CDF of a mixture distribution function is \deqn{F(A)=\sum w_{i}F_{i}(A)}, where
         \eqn{w_{i}} is the weight of the i-th component and \eqn{F_{i}()} is the CDF of the i-th component.

         The objects can be specified in two ways, either the user may enter
         distribution objects or a vector of names and list of parameters.
         See the examples below.
}
\examples{
# using the objects
M <- mixdist(normdist(1, 3), expdist(4), weights = c(0.7, 0.3))
M

# using the names and parameters
M2 <- mixdist(c("norm", "exp"), list(c(mean = 1, sd = 3), c(rate = 4)),
              weights = c(0.7, 0.3))
M2
}
\seealso{
\code{\link{compdist}}
}
