% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galasso.R
\name{galasso}
\alias{galasso}
\title{Multiple Imputation Grouped Adaptive LASSO}
\usage{
galasso(
  x,
  y,
  pf,
  adWeight,
  family = c("gaussian", "binomial"),
  nlambda = 100,
  lambda.min.ratio = ifelse(all.equal(adWeight, rep(1, p)), 0.001, 1e-06),
  lambda = NULL,
  maxit = 10000,
  eps = 1e-05
)
}
\arguments{
\item{x}{A length \code{m} list of \code{n * p} numeric matrices. No matrix
should contain an intercept, or any missing values}

\item{y}{A length \code{m} list of length \code{n} numeric response vectors.
No vector should contain missing values}

\item{pf}{Penalty factor. Can be used to differentially penalize certain
variables}

\item{adWeight}{Numeric vector of length p representing the adaptive weights
for the L1 penalty}

\item{family}{The type of response. "gaussian" implies a continuous response
and "binomial" implies a binary response. Default is "gaussian".}

\item{nlambda}{Length of automatically generated 'lambda' sequence. If
lambda' is non NULL, 'nlambda' is ignored. Default is 100}

\item{lambda.min.ratio}{Ratio that determines the minimum value of 'lambda'
when automatically generating a 'lambda' sequence. If 'lambda' is not
NULL, 'lambda.min.ratio' is ignored. Default is 1e-4}

\item{lambda}{Optional numeric vector of lambdas to fit. If NULL,
\code{galasso} will automatically generate a lambda sequence based off
of \code{nlambda} and code{lambda.min.ratio}. Default is NULL}

\item{maxit}{Maximum number of iterations to run. Default is 10000}

\item{eps}{Tolerance for convergence. Default is 1e-5}
}
\value{
An object with type "galasso" and subtype
"galasso.gaussian" or galasso.binomial", depending on which family was used.
Both subtypes have 4 elements:
\describe{
\item{lambda}{Sequence of lambda fit.}
\item{beta}{p + 1 x nlambda matrix representing the estimated betas at
            each value of lambda. The betas are constructed as the average
            of the betas from each imputation.}
\item{df}{Number of nonzero betas at each value of lambda.}
\item{mse}{For objects with subtype "galasso.gaussian", the training MSE for
           each value of lambda.}
\item{dev}{For objects with subtype "galasso.binomial", the training deviance
           for each value of lambda.}
}
}
\description{
\code{galasso} fits an adaptive LASSO for multiply imputed data. "galasso"
supports both continuous and binary responses.
}
\details{
\code{galasso} works by adding a group penalty to the aggregated objective
function to ensure selection consistency across imputations. The objective
function is:

\deqn{argmin_{\beta_{jk}} - L(\beta_{jk}| X_{ijk}, Y_{ik})}
\deqn{+ \lambda * \Sigma_{j=1}^{p} \hat{a}_j * pf_j * \sqrt{\Sigma_{k=1}^{m} \beta_{jk}^2}}
Where L is the log likelihood,\code{a} is the adaptive weights, and
\code{pf} is the penalty factor. Simulations suggest that the "stacked"
objective function approach (i.e., \code{saenet}) tends to be more
computationally efficient and have better estimation and selection
properties. However, the advantage of \code{galasso} is that it allows one
to look at the differences between coefficient estimates across imputations.
}
\examples{
\donttest{
library(miselect)
library(mice)

mids <- mice(miselect.df, m = 5, printFlag = FALSE)
dfs <- lapply(1:5, function(i) complete(mids, action = i))

# Generate list of imputed design matrices and imputed responses
x <- list()
y <- list()
for (i in 1:5) {
    x[[i]] <- as.matrix(dfs[[i]][, paste0("X", 1:20)])
    y[[i]] <- dfs[[i]]$Y
}

pf       <- rep(1, 20)
adWeight <- rep(1, 20)

fit <- galasso(x, y, pf, adWeight)
}
}
\references{
Variable selection with multiply-imputed datasets: choosing between stacked
and grouped methods. Jiacong Du, Jonathan Boss, Peisong Han, Lauren J Beesley,
Stephen A Goutman, Stuart Batterman, Eva L Feldman, and Bhramar Mukherjee. 2020.
arXiv:2003.07398
}
