% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{stop_mirai}
\alias{stop_mirai}
\title{mirai (Stop)}
\usage{
stop_mirai(x)
}
\arguments{
\item{x}{a 'mirai' object, or list of 'mirai' objects.}
}
\value{
Logical TRUE if the cancellation request was successful (was awaiting
execution or in execution), or else FALSE (if already completed or
previously cancelled). Will always return FALSE if not using dispatcher.

\strong{Or} a vector of logical values if supplying a list of 'mirai', such as
those returned by \code{\link[=mirai_map]{mirai_map()}}.
}
\description{
Stops a 'mirai' if still in progress, causing it to resolve immediately to an
'errorValue' 20 (Operation canceled).
}
\details{
Using dispatcher allows cancellation of 'mirai'. In the case that the 'mirai'
is awaiting execution, it is discarded from the queue and never evaluated. In
the case it is already in execution, an interrupt will be sent.

A successful cancellation request does not guarantee successful cancellation:
the task, or a portion of it, may have already completed before the interrupt
is received. Even then, compiled code is not always interruptible. This
should be noted, particularly if the code carries out side effects during
execution, such as writing to files, etc.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- mirai(Sys.sleep(n), n = 5)
stop_mirai(m)
m$data
\dontshow{\}) # examplesIf}
}
