% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{mirai}
\alias{mirai}
\title{mirai (Evaluate Async)}
\usage{
mirai(.expr, ..., .args = list(), .timeout = NULL, .compute = "default")
}
\arguments{
\item{.expr}{an expression to evaluate asynchronously. This may be of
arbitrary length, wrapped in \{\} if necessary.}

\item{...}{(optional) named arguments specifying objects referenced in '.expr'.}

\item{.args}{(optional) list supplying objects referenced in '.expr' (used in
addition to or instead of named arguments specified as '...').}

\item{.timeout}{(optional) integer value in milliseconds or NULL for no
timeout. A mirai will resolve to an 'errorValue' 5 (timed out) if
evaluation exceeds this limit.}

\item{.compute}{(optional) character value for the compute profile to use
when sending the mirai.}
}
\value{
A 'mirai' object.
}
\description{
Evaluate an expression asynchronously in a new background R process or
    persistent daemon (local or remote). This function will return
    immediately with a 'mirai', which will resolve to the evaluated result
    once complete.
}
\details{
This function will return a 'mirai' object immediately.

    The value of a mirai may be accessed at any time at \code{$data}, and
    if yet to resolve, an 'unresolved' logical NA will be returned instead.

    \code{\link{unresolved}} may be used on a mirai, returning TRUE if a
    'mirai' has yet to resolve and FALSE otherwise. This is suitable for use
    in control flow statements such as \code{while} or \code{if}.

    Alternatively, to call (and wait for) the result, use \code{\link{call_mirai}}
    on the returned mirai. This will block until the result is returned
    (although interruptible with e.g. ctrl+c).

    The expression '.expr' will be evaluated in a separate R process in a
    clean environment consisting only of the named objects passed as '...'
    and/or the list supplied to '.args'.

    If an error occurs in evaluation, the error message is returned as a
    character string of class 'miraiError' and 'errorValue'.
    \code{\link{is_mirai_error}} may be used to test for this.

    \code{\link{is_error_value}} tests for all error conditions including
    'mirai' errors, interrupts, and timeouts.

    Specify '.compute' to send the mirai to a specific server destination, if
    multiple compute profiles have been set up via \code{\link{daemons}},
    otherwise leave as 'default'.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(x + y + 1, x = 2, y = 3)
m
m$data
Sys.sleep(0.2)
m$data

df1 <- data.frame(a = 1, b = 2)
df2 <- data.frame(a = 3, b = 1)
m <- mirai(as.matrix(rbind(df1, df2)), .args = list(df1, df2), .timeout = 1000)
call_mirai(m)$data

m <- mirai({
  res <- rnorm(n)
  res / rev(res)
}, n = 1e6)
while (unresolved(m)) {
  cat("unresolved\n")
  Sys.sleep(0.1)
}
str(m$data)

file <- tempfile()
cat("r <- rnorm(n)", file = file)
n <- 10L
m <- mirai({source(file, local = TRUE); r}, .args = list(file, n))
call_mirai(m)[["data"]]
unlink(file)

}

}
