% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_metrics.R
\name{calc_perf_metrics}
\alias{calc_perf_metrics}
\title{Get performance metrics for test data}
\usage{
calc_perf_metrics(
  test_data,
  trained_model,
  outcome_colname,
  perf_metric_function,
  class_probs
)
}
\arguments{
\item{test_data}{Held out test data: dataframe of outcome and features.}

\item{trained_model}{Trained model from \code{\link[caret:train]{caret::train()}}.}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}

\item{perf_metric_function}{Function to calculate the performance metric to
be used for cross-validation and test performance. Some functions are
provided by caret (see \code{\link[caret:postResample]{caret::defaultSummary()}}).
Defaults: binary classification = \code{twoClassSummary},
multi-class classification = \code{multiClassSummary},
regression = \code{defaultSummary}.}

\item{class_probs}{Whether to use class probabilities (TRUE for categorical outcomes, FALSE for numeric outcomes).}
}
\value{
Dataframe of performance metrics.
}
\description{
Get performance metrics for test data
}
\examples{
\dontrun{
results <- run_ml(otu_small, "glmnet", kfold = 2, cv_times = 2)
calc_perf_metrics(results$test_data,
  results$trained_model,
  "dx",
  multiClassSummary,
  class_probs = TRUE
)
}
}
\author{
Zena Lapp, \email{zenalapp@umich.edu}
}
