% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordreg.R
\name{ordreg}
\alias{ordreg}
\alias{fitted.ordreg}
\title{Ordered regression}
\usage{
ordreg(
  formula,
  data,
  weights,
  subset,
  na.action,
  offset,
  contrasts = NULL,
  link = c("probit", "logit", "cloglog"),
  start = NULL,
  opt = c("bfgs", "nr", "newton"),
  maxit = 100,
  trace = 0,
  check_gradient = FALSE,
  ...
)

\method{fitted}{ordreg}(object, ..., type = c("outcome", "probabilities"))
}
\arguments{
\item{formula}{a symbolic description of the model}

\item{data}{a data frame}

\item{subset, weights, na.action, offset, contrasts}{see \code{lm}}

\item{link}{one of \code{probit} and \code{logit}}

\item{start}{a vector of starting values,}

\item{opt}{optimization method}

\item{maxit}{maximum number of iterations}

\item{trace}{printing of intermediate result}

\item{check_gradient}{if \code{TRUE} the numeric gradient and hessian
are computed and compared to the analytical gradient and
hessian}

\item{...}{further arguments}

\item{object}{a \code{ordreg} object}

\item{type}{one of \code{"outcome"} or \code{"probabilities"} for the
\code{fitted} method}
}
\value{
an object of class \code{micsr}, see \code{micsr::micsr} for further
details.
}
\description{
Maximum-likelihood estimation of a model for which the response is
ordinal
}
\examples{
mod1 <- ordreg(factor(dindx) ~ rhs1 + catchup, fin_reform, link = "logit")
library(survival)
ud <- transform(unemp_duration, years = floor(duration / 365))
ud <- transform(ud, years = ifelse(years == 6, 5, years))
mod2 <- ordreg(Surv(years, censored == "no") ~ gender + age + log(1 + wage), ud,
               link = "cloglog", opt = "bfgs")
}
\keyword{models}
