% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{scoretest}
\alias{scoretest}
\alias{scoretest.micsr}
\title{Score test}
\usage{
scoretest(x, y, ...)

\method{scoretest}{micsr}(x, y, ..., vcov = NULL)
}
\arguments{
\item{x}{the first model,}

\item{y}{the second model}

\item{...}{further arguments}

\item{vcov}{omit a character containing the effects that are
removed from the test}
}
\value{
an object of class \code{"htest"}.
}
\description{
Score test, also knowned as Lagrange multiplier tests
}
\examples{
mode_choice <- mode_choice \%>\%
   mutate(cost = cost * 8.42,
          gcost = (ivtime + ovtime) * 8 + cost)
pbt_unconst <- binomreg(mode ~ cost + ivtime + ovtime, data = mode_choice, link = "probit")
pbt_const <- binomreg(mode ~ gcost, data = mode_choice, link = "logit")
scoretest(pbt_const , . ~ . + ivtime + ovtime)
}
\author{
Yves Croissant
}
\keyword{htest}
