% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnaManipulate.R
\name{iupac2regex}
\alias{iupac2regex}
\alias{uipac2regex}
\alias{regex2iupac}
\title{Ambiguity symbol conversion}
\usage{
iupac2regex( sequence )
regex2iupac( sequence )
}
\arguments{
\item{sequence}{Character string containing a DNA sequence.}
}
\value{
A string where the ambiguity symbol has been replaced by a regular expression
(\code{iupac2regex}) or a regular expression has been replaced by an ambiguity symbol
(\code{regex2iupac}).
}
\description{
Converting DNA ambiguity symbols to regular expressions, and vice versa.
}
\details{
The DNA alphabet may contain ambiguity symbols, e.g. a W means either A or T.
When using a regular expression search, these letters must be replaced by the proper
regular expression, e.g. W is replaced by [AT] in the string. The \code{iupac2regex} makes this
translation, while \code{regex2iupac} cobverts the other way again (replace [AT] with W).
}
\examples{
iupac2regex( "ACWGT" )
regex2iupac( "AC[AG]GT" )

}
\author{
Lars Snipen.
}
